package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class KafkaExporterSpecBuilder extends KafkaExporterSpecFluentImpl<KafkaExporterSpecBuilder> implements VisitableBuilder<KafkaExporterSpec,KafkaExporterSpecBuilder>{

    KafkaExporterSpecFluent<?> fluent;
    Boolean validationEnabled;

    public KafkaExporterSpecBuilder(){
            this(true);
    }
    public KafkaExporterSpecBuilder(Boolean validationEnabled){
            this(new KafkaExporterSpec(), validationEnabled);
    }
    public KafkaExporterSpecBuilder(KafkaExporterSpecFluent<?> fluent){
            this(fluent, true);
    }
    public KafkaExporterSpecBuilder(KafkaExporterSpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new KafkaExporterSpec(), validationEnabled);
    }
    public KafkaExporterSpecBuilder(KafkaExporterSpecFluent<?> fluent,KafkaExporterSpec instance){
            this(fluent, instance, true);
    }
    public KafkaExporterSpecBuilder(KafkaExporterSpecFluent<?> fluent,KafkaExporterSpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withImage(instance.getImage());

            fluent.withGroupRegex(instance.getGroupRegex());

            fluent.withTopicRegex(instance.getTopicRegex());

            fluent.withResources(instance.getResources());

            fluent.withLivenessProbe(instance.getLivenessProbe());

            fluent.withReadinessProbe(instance.getReadinessProbe());

            fluent.withLogging(instance.getLogging());

            fluent.withEnableSaramaLogging(instance.getEnableSaramaLogging());

            fluent.withTemplate(instance.getTemplate());

            this.validationEnabled = validationEnabled; 
    }
    public KafkaExporterSpecBuilder(KafkaExporterSpec instance){
            this(instance,true);
    }
    public KafkaExporterSpecBuilder(KafkaExporterSpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withImage(instance.getImage());

            this.withGroupRegex(instance.getGroupRegex());

            this.withTopicRegex(instance.getTopicRegex());

            this.withResources(instance.getResources());

            this.withLivenessProbe(instance.getLivenessProbe());

            this.withReadinessProbe(instance.getReadinessProbe());

            this.withLogging(instance.getLogging());

            this.withEnableSaramaLogging(instance.getEnableSaramaLogging());

            this.withTemplate(instance.getTemplate());

            this.validationEnabled = validationEnabled; 
    }

    public KafkaExporterSpec build(){
            KafkaExporterSpec buildable = new KafkaExporterSpec();
            buildable.setImage(fluent.getImage());
            buildable.setGroupRegex(fluent.getGroupRegex());
            buildable.setTopicRegex(fluent.getTopicRegex());
            buildable.setResources(fluent.getResources());
            buildable.setLivenessProbe(fluent.getLivenessProbe());
            buildable.setReadinessProbe(fluent.getReadinessProbe());
            buildable.setLogging(fluent.getLogging());
            buildable.setEnableSaramaLogging(fluent.isEnableSaramaLogging());
            buildable.setTemplate(fluent.getTemplate());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            KafkaExporterSpecBuilder that = (KafkaExporterSpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
