package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class KafkaMirrorMaker2ClusterSpecBuilder extends KafkaMirrorMaker2ClusterSpecFluentImpl<KafkaMirrorMaker2ClusterSpecBuilder> implements VisitableBuilder<KafkaMirrorMaker2ClusterSpec,KafkaMirrorMaker2ClusterSpecBuilder>{

    KafkaMirrorMaker2ClusterSpecFluent<?> fluent;
    Boolean validationEnabled;

    public KafkaMirrorMaker2ClusterSpecBuilder(){
            this(true);
    }
    public KafkaMirrorMaker2ClusterSpecBuilder(Boolean validationEnabled){
            this(new KafkaMirrorMaker2ClusterSpec(), validationEnabled);
    }
    public KafkaMirrorMaker2ClusterSpecBuilder(KafkaMirrorMaker2ClusterSpecFluent<?> fluent){
            this(fluent, true);
    }
    public KafkaMirrorMaker2ClusterSpecBuilder(KafkaMirrorMaker2ClusterSpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new KafkaMirrorMaker2ClusterSpec(), validationEnabled);
    }
    public KafkaMirrorMaker2ClusterSpecBuilder(KafkaMirrorMaker2ClusterSpecFluent<?> fluent,KafkaMirrorMaker2ClusterSpec instance){
            this(fluent, instance, true);
    }
    public KafkaMirrorMaker2ClusterSpecBuilder(KafkaMirrorMaker2ClusterSpecFluent<?> fluent,KafkaMirrorMaker2ClusterSpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withAlias(instance.getAlias());

            fluent.withBootstrapServers(instance.getBootstrapServers());

            fluent.withConfig(instance.getConfig());

            fluent.withTls(instance.getTls());

            fluent.withAuthentication(instance.getAuthentication());

            this.validationEnabled = validationEnabled; 
    }
    public KafkaMirrorMaker2ClusterSpecBuilder(KafkaMirrorMaker2ClusterSpec instance){
            this(instance,true);
    }
    public KafkaMirrorMaker2ClusterSpecBuilder(KafkaMirrorMaker2ClusterSpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withAlias(instance.getAlias());

            this.withBootstrapServers(instance.getBootstrapServers());

            this.withConfig(instance.getConfig());

            this.withTls(instance.getTls());

            this.withAuthentication(instance.getAuthentication());

            this.validationEnabled = validationEnabled; 
    }

    public KafkaMirrorMaker2ClusterSpec build(){
            KafkaMirrorMaker2ClusterSpec buildable = new KafkaMirrorMaker2ClusterSpec();
            buildable.setAlias(fluent.getAlias());
            buildable.setBootstrapServers(fluent.getBootstrapServers());
            buildable.setConfig(fluent.getConfig());
            buildable.setTls(fluent.getTls());
            buildable.setAuthentication(fluent.getAuthentication());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            KafkaMirrorMaker2ClusterSpecBuilder that = (KafkaMirrorMaker2ClusterSpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
