package io.strimzi.api.kafka.model;

import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuthBuilder;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha512Builder;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuth;
import java.lang.Deprecated;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationPlainBuilder;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationTlsBuilder;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuthFluent;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationPlain;
import java.lang.Boolean;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha512;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationTls;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha512Fluent;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthentication;
import java.lang.StringBuffer;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationPlainFluent;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationTlsFluent;
import java.lang.Object;
import java.util.Map;

public interface KafkaMirrorMaker2ClusterSpecFluent<A extends KafkaMirrorMaker2ClusterSpecFluent<A>> extends Fluent<A>{


    public String getAlias();
    public A withAlias(String alias);
    public Boolean hasAlias();
    public A withNewAlias(String arg1);
    public A withNewAlias(StringBuilder arg1);
    public A withNewAlias(StringBuffer arg1);
    public String getBootstrapServers();
    public A withBootstrapServers(String bootstrapServers);
    public Boolean hasBootstrapServers();
    public A withNewBootstrapServers(String arg1);
    public A withNewBootstrapServers(StringBuilder arg1);
    public A withNewBootstrapServers(StringBuffer arg1);
    public A addToConfig(String key,Object value);
    public A addToConfig(Map<String,Object> map);
    public A removeFromConfig(String key);
    public A removeFromConfig(Map<String,Object> map);
    public Map<String,Object> getConfig();
    public A withConfig(Map<String,Object> config);
    public Boolean hasConfig();
    
/**
 * This method has been deprecated, please use method buildTls instead.
 * @return The buildable object.
 */
@Deprecated public KafkaMirrorMaker2Tls getTls();
    public KafkaMirrorMaker2Tls buildTls();
    public A withTls(KafkaMirrorMaker2Tls tls);
    public Boolean hasTls();
    public KafkaMirrorMaker2ClusterSpecFluent.TlsNested<A> withNewTls();
    public KafkaMirrorMaker2ClusterSpecFluent.TlsNested<A> withNewTlsLike(KafkaMirrorMaker2Tls item);
    public KafkaMirrorMaker2ClusterSpecFluent.TlsNested<A> editTls();
    public KafkaMirrorMaker2ClusterSpecFluent.TlsNested<A> editOrNewTls();
    public KafkaMirrorMaker2ClusterSpecFluent.TlsNested<A> editOrNewTlsLike(KafkaMirrorMaker2Tls item);
    
/**
 * This method has been deprecated, please use method buildAuthentication instead.
 * @return The buildable object.
 */
@Deprecated public KafkaClientAuthentication getAuthentication();
    public KafkaClientAuthentication buildAuthentication();
    public A withAuthentication(KafkaClientAuthentication authentication);
    public Boolean hasAuthentication();
    public A withKafkaClientAuthenticationScramSha512(KafkaClientAuthenticationScramSha512 kafkaClientAuthenticationScramSha512);
    public KafkaMirrorMaker2ClusterSpecFluent.KafkaClientAuthenticationScramSha512Nested<A> withNewKafkaClientAuthenticationScramSha512();
    public KafkaMirrorMaker2ClusterSpecFluent.KafkaClientAuthenticationScramSha512Nested<A> withNewKafkaClientAuthenticationScramSha512Like(KafkaClientAuthenticationScramSha512 item);
    public A withKafkaClientAuthenticationPlain(KafkaClientAuthenticationPlain kafkaClientAuthenticationPlain);
    public KafkaMirrorMaker2ClusterSpecFluent.KafkaClientAuthenticationPlainNested<A> withNewKafkaClientAuthenticationPlain();
    public KafkaMirrorMaker2ClusterSpecFluent.KafkaClientAuthenticationPlainNested<A> withNewKafkaClientAuthenticationPlainLike(KafkaClientAuthenticationPlain item);
    public A withKafkaClientAuthenticationOAuth(KafkaClientAuthenticationOAuth kafkaClientAuthenticationOAuth);
    public KafkaMirrorMaker2ClusterSpecFluent.KafkaClientAuthenticationOAuthNested<A> withNewKafkaClientAuthenticationOAuth();
    public KafkaMirrorMaker2ClusterSpecFluent.KafkaClientAuthenticationOAuthNested<A> withNewKafkaClientAuthenticationOAuthLike(KafkaClientAuthenticationOAuth item);
    public A withKafkaClientAuthenticationTls(KafkaClientAuthenticationTls kafkaClientAuthenticationTls);
    public KafkaMirrorMaker2ClusterSpecFluent.KafkaClientAuthenticationTlsNested<A> withNewKafkaClientAuthenticationTls();
    public KafkaMirrorMaker2ClusterSpecFluent.KafkaClientAuthenticationTlsNested<A> withNewKafkaClientAuthenticationTlsLike(KafkaClientAuthenticationTls item);

    public interface TlsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,KafkaMirrorMaker2TlsFluent<KafkaMirrorMaker2ClusterSpecFluent.TlsNested<N>>{

        
    public N and();    public N endTls();
}
    public interface KafkaClientAuthenticationScramSha512Nested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,KafkaClientAuthenticationScramSha512Fluent<KafkaMirrorMaker2ClusterSpecFluent.KafkaClientAuthenticationScramSha512Nested<N>>{

        
    public N and();    public N endKafkaClientAuthenticationScramSha512();
}
    public interface KafkaClientAuthenticationPlainNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,KafkaClientAuthenticationPlainFluent<KafkaMirrorMaker2ClusterSpecFluent.KafkaClientAuthenticationPlainNested<N>>{

        
    public N and();    public N endKafkaClientAuthenticationPlain();
}
    public interface KafkaClientAuthenticationOAuthNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,KafkaClientAuthenticationOAuthFluent<KafkaMirrorMaker2ClusterSpecFluent.KafkaClientAuthenticationOAuthNested<N>>{

        
    public N and();    public N endKafkaClientAuthenticationOAuth();
}
    public interface KafkaClientAuthenticationTlsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,KafkaClientAuthenticationTlsFluent<KafkaMirrorMaker2ClusterSpecFluent.KafkaClientAuthenticationTlsNested<N>>{

        
    public N and();    public N endKafkaClientAuthenticationTls();
}


}
