package io.strimzi.api.kafka.model;

import io.strimzi.api.kafka.model.status.KafkaMirrorMaker2StatusFluentImpl;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import io.strimzi.api.kafka.model.status.KafkaMirrorMaker2Status;
import java.lang.String;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.strimzi.api.kafka.model.status.KafkaMirrorMaker2StatusBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.StringBuffer;
import java.lang.Object;

public class KafkaMirrorMaker2FluentImpl<A extends KafkaMirrorMaker2Fluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements KafkaMirrorMaker2Fluent<A>{

    private String apiVersion;
    private KafkaMirrorMaker2SpecBuilder spec;
    private ObjectMetaBuilder metadata;
    private KafkaMirrorMaker2StatusBuilder status;

    public KafkaMirrorMaker2FluentImpl(){
    }
    public KafkaMirrorMaker2FluentImpl(KafkaMirrorMaker2 instance){
            this.withApiVersion(instance.getApiVersion());

            this.withSpec(instance.getSpec());

            this.withMetadata(instance.getMetadata());

            this.withStatus(instance.getStatus());

    }

    public String getApiVersion(){
            return this.apiVersion;
    }

    public A withApiVersion(String apiVersion){
            this.apiVersion=apiVersion; return (A) this;
    }

    public Boolean hasApiVersion(){
            return this.apiVersion != null;
    }

    public A withNewApiVersion(String arg1){
            return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuilder arg1){
            return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuffer arg1){
            return (A)withApiVersion(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildSpec instead.
 * @return The buildable object.
 */
@Deprecated public KafkaMirrorMaker2Spec getSpec(){
            return this.spec!=null?this.spec.build():null;
    }

    public KafkaMirrorMaker2Spec buildSpec(){
            return this.spec!=null?this.spec.build():null;
    }

    public A withSpec(KafkaMirrorMaker2Spec spec){
            _visitables.get("spec").remove(this.spec);
            if (spec!=null){ this.spec= new KafkaMirrorMaker2SpecBuilder(spec); _visitables.get("spec").add(this.spec);} return (A) this;
    }

    public Boolean hasSpec(){
            return this.spec != null;
    }

    public KafkaMirrorMaker2Fluent.SpecNested<A> withNewSpec(){
            return new SpecNestedImpl();
    }

    public KafkaMirrorMaker2Fluent.SpecNested<A> withNewSpecLike(KafkaMirrorMaker2Spec item){
            return new SpecNestedImpl(item);
    }

    public KafkaMirrorMaker2Fluent.SpecNested<A> editSpec(){
            return withNewSpecLike(getSpec());
    }

    public KafkaMirrorMaker2Fluent.SpecNested<A> editOrNewSpec(){
            return withNewSpecLike(getSpec() != null ? getSpec(): new KafkaMirrorMaker2SpecBuilder().build());
    }

    public KafkaMirrorMaker2Fluent.SpecNested<A> editOrNewSpecLike(KafkaMirrorMaker2Spec item){
            return withNewSpecLike(getSpec() != null ? getSpec(): item);
    }

    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public ObjectMeta getMetadata(){
            return this.metadata!=null?this.metadata.build():null;
    }

    public ObjectMeta buildMetadata(){
            return this.metadata!=null?this.metadata.build():null;
    }

    public A withMetadata(ObjectMeta metadata){
            _visitables.get("metadata").remove(this.metadata);
            if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} return (A) this;
    }

    public Boolean hasMetadata(){
            return this.metadata != null;
    }

    public KafkaMirrorMaker2Fluent.MetadataNested<A> withNewMetadata(){
            return new MetadataNestedImpl();
    }

    public KafkaMirrorMaker2Fluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item){
            return new MetadataNestedImpl(item);
    }

    public KafkaMirrorMaker2Fluent.MetadataNested<A> editMetadata(){
            return withNewMetadataLike(getMetadata());
    }

    public KafkaMirrorMaker2Fluent.MetadataNested<A> editOrNewMetadata(){
            return withNewMetadataLike(getMetadata() != null ? getMetadata(): new ObjectMetaBuilder().build());
    }

    public KafkaMirrorMaker2Fluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item){
            return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
    }

    
/**
 * This method has been deprecated, please use method buildStatus instead.
 * @return The buildable object.
 */
@Deprecated public KafkaMirrorMaker2Status getStatus(){
            return this.status!=null?this.status.build():null;
    }

    public KafkaMirrorMaker2Status buildStatus(){
            return this.status!=null?this.status.build():null;
    }

    public A withStatus(KafkaMirrorMaker2Status status){
            _visitables.get("status").remove(this.status);
            if (status!=null){ this.status= new KafkaMirrorMaker2StatusBuilder(status); _visitables.get("status").add(this.status);} return (A) this;
    }

    public Boolean hasStatus(){
            return this.status != null;
    }

    public KafkaMirrorMaker2Fluent.StatusNested<A> withNewStatus(){
            return new StatusNestedImpl();
    }

    public KafkaMirrorMaker2Fluent.StatusNested<A> withNewStatusLike(KafkaMirrorMaker2Status item){
            return new StatusNestedImpl(item);
    }

    public KafkaMirrorMaker2Fluent.StatusNested<A> editStatus(){
            return withNewStatusLike(getStatus());
    }

    public KafkaMirrorMaker2Fluent.StatusNested<A> editOrNewStatus(){
            return withNewStatusLike(getStatus() != null ? getStatus(): new KafkaMirrorMaker2StatusBuilder().build());
    }

    public KafkaMirrorMaker2Fluent.StatusNested<A> editOrNewStatusLike(KafkaMirrorMaker2Status item){
            return withNewStatusLike(getStatus() != null ? getStatus(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            KafkaMirrorMaker2FluentImpl that = (KafkaMirrorMaker2FluentImpl) o;
            if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
            if (spec != null ? !spec.equals(that.spec) :that.spec != null) return false;
            if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
            if (status != null ? !status.equals(that.status) :that.status != null) return false;
            return true;
    }


    public class SpecNestedImpl<N> extends KafkaMirrorMaker2SpecFluentImpl<KafkaMirrorMaker2Fluent.SpecNested<N>> implements KafkaMirrorMaker2Fluent.SpecNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final KafkaMirrorMaker2SpecBuilder builder;
    
            SpecNestedImpl(KafkaMirrorMaker2Spec item){
                    this.builder = new KafkaMirrorMaker2SpecBuilder(this, item);
            }
            SpecNestedImpl(){
                    this.builder = new KafkaMirrorMaker2SpecBuilder(this);
            }
    
    public N and(){
            return (N) KafkaMirrorMaker2FluentImpl.this.withSpec(builder.build());
    }
    public N endSpec(){
            return and();
    }

}
    public class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<KafkaMirrorMaker2Fluent.MetadataNested<N>> implements KafkaMirrorMaker2Fluent.MetadataNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ObjectMetaBuilder builder;
    
            MetadataNestedImpl(ObjectMeta item){
                    this.builder = new ObjectMetaBuilder(this, item);
            }
            MetadataNestedImpl(){
                    this.builder = new ObjectMetaBuilder(this);
            }
    
    public N and(){
            return (N) KafkaMirrorMaker2FluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata(){
            return and();
    }

}
    public class StatusNestedImpl<N> extends KafkaMirrorMaker2StatusFluentImpl<KafkaMirrorMaker2Fluent.StatusNested<N>> implements KafkaMirrorMaker2Fluent.StatusNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final KafkaMirrorMaker2StatusBuilder builder;
    
            StatusNestedImpl(KafkaMirrorMaker2Status item){
                    this.builder = new KafkaMirrorMaker2StatusBuilder(this, item);
            }
            StatusNestedImpl(){
                    this.builder = new KafkaMirrorMaker2StatusBuilder(this);
            }
    
    public N and(){
            return (N) KafkaMirrorMaker2FluentImpl.this.withStatus(builder.build());
    }
    public N endStatus(){
            return and();
    }

}


}
