package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class KafkaMirrorMaker2MirrorSpecBuilder extends KafkaMirrorMaker2MirrorSpecFluentImpl<KafkaMirrorMaker2MirrorSpecBuilder> implements VisitableBuilder<KafkaMirrorMaker2MirrorSpec,KafkaMirrorMaker2MirrorSpecBuilder>{

    KafkaMirrorMaker2MirrorSpecFluent<?> fluent;
    Boolean validationEnabled;

    public KafkaMirrorMaker2MirrorSpecBuilder(){
            this(true);
    }
    public KafkaMirrorMaker2MirrorSpecBuilder(Boolean validationEnabled){
            this(new KafkaMirrorMaker2MirrorSpec(), validationEnabled);
    }
    public KafkaMirrorMaker2MirrorSpecBuilder(KafkaMirrorMaker2MirrorSpecFluent<?> fluent){
            this(fluent, true);
    }
    public KafkaMirrorMaker2MirrorSpecBuilder(KafkaMirrorMaker2MirrorSpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new KafkaMirrorMaker2MirrorSpec(), validationEnabled);
    }
    public KafkaMirrorMaker2MirrorSpecBuilder(KafkaMirrorMaker2MirrorSpecFluent<?> fluent,KafkaMirrorMaker2MirrorSpec instance){
            this(fluent, instance, true);
    }
    public KafkaMirrorMaker2MirrorSpecBuilder(KafkaMirrorMaker2MirrorSpecFluent<?> fluent,KafkaMirrorMaker2MirrorSpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withSourceCluster(instance.getSourceCluster());

            fluent.withTargetCluster(instance.getTargetCluster());

            fluent.withSourceConnector(instance.getSourceConnector());

            fluent.withCheckpointConnector(instance.getCheckpointConnector());

            fluent.withHeartbeatConnector(instance.getHeartbeatConnector());

            fluent.withTopicsPattern(instance.getTopicsPattern());

            fluent.withTopicsBlacklistPattern(instance.getTopicsBlacklistPattern());

            fluent.withGroupsPattern(instance.getGroupsPattern());

            fluent.withGroupsBlacklistPattern(instance.getGroupsBlacklistPattern());

            this.validationEnabled = validationEnabled; 
    }
    public KafkaMirrorMaker2MirrorSpecBuilder(KafkaMirrorMaker2MirrorSpec instance){
            this(instance,true);
    }
    public KafkaMirrorMaker2MirrorSpecBuilder(KafkaMirrorMaker2MirrorSpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withSourceCluster(instance.getSourceCluster());

            this.withTargetCluster(instance.getTargetCluster());

            this.withSourceConnector(instance.getSourceConnector());

            this.withCheckpointConnector(instance.getCheckpointConnector());

            this.withHeartbeatConnector(instance.getHeartbeatConnector());

            this.withTopicsPattern(instance.getTopicsPattern());

            this.withTopicsBlacklistPattern(instance.getTopicsBlacklistPattern());

            this.withGroupsPattern(instance.getGroupsPattern());

            this.withGroupsBlacklistPattern(instance.getGroupsBlacklistPattern());

            this.validationEnabled = validationEnabled; 
    }

    public KafkaMirrorMaker2MirrorSpec build(){
            KafkaMirrorMaker2MirrorSpec buildable = new KafkaMirrorMaker2MirrorSpec();
            buildable.setSourceCluster(fluent.getSourceCluster());
            buildable.setTargetCluster(fluent.getTargetCluster());
            buildable.setSourceConnector(fluent.getSourceConnector());
            buildable.setCheckpointConnector(fluent.getCheckpointConnector());
            buildable.setHeartbeatConnector(fluent.getHeartbeatConnector());
            buildable.setTopicsPattern(fluent.getTopicsPattern());
            buildable.setTopicsBlacklistPattern(fluent.getTopicsBlacklistPattern());
            buildable.setGroupsPattern(fluent.getGroupsPattern());
            buildable.setGroupsBlacklistPattern(fluent.getGroupsBlacklistPattern());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            KafkaMirrorMaker2MirrorSpecBuilder that = (KafkaMirrorMaker2MirrorSpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
