package io.strimzi.api.kafka.model;

import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

public interface KafkaMirrorMaker2MirrorSpecFluent<A extends KafkaMirrorMaker2MirrorSpecFluent<A>> extends Fluent<A>{


    public String getSourceCluster();
    public A withSourceCluster(String sourceCluster);
    public Boolean hasSourceCluster();
    public A withNewSourceCluster(String arg1);
    public A withNewSourceCluster(StringBuilder arg1);
    public A withNewSourceCluster(StringBuffer arg1);
    public String getTargetCluster();
    public A withTargetCluster(String targetCluster);
    public Boolean hasTargetCluster();
    public A withNewTargetCluster(String arg1);
    public A withNewTargetCluster(StringBuilder arg1);
    public A withNewTargetCluster(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildSourceConnector instead.
 * @return The buildable object.
 */
@Deprecated public KafkaMirrorMaker2ConnectorSpec getSourceConnector();
    public KafkaMirrorMaker2ConnectorSpec buildSourceConnector();
    public A withSourceConnector(KafkaMirrorMaker2ConnectorSpec sourceConnector);
    public Boolean hasSourceConnector();
    public KafkaMirrorMaker2MirrorSpecFluent.SourceConnectorNested<A> withNewSourceConnector();
    public KafkaMirrorMaker2MirrorSpecFluent.SourceConnectorNested<A> withNewSourceConnectorLike(KafkaMirrorMaker2ConnectorSpec item);
    public KafkaMirrorMaker2MirrorSpecFluent.SourceConnectorNested<A> editSourceConnector();
    public KafkaMirrorMaker2MirrorSpecFluent.SourceConnectorNested<A> editOrNewSourceConnector();
    public KafkaMirrorMaker2MirrorSpecFluent.SourceConnectorNested<A> editOrNewSourceConnectorLike(KafkaMirrorMaker2ConnectorSpec item);
    
/**
 * This method has been deprecated, please use method buildCheckpointConnector instead.
 * @return The buildable object.
 */
@Deprecated public KafkaMirrorMaker2ConnectorSpec getCheckpointConnector();
    public KafkaMirrorMaker2ConnectorSpec buildCheckpointConnector();
    public A withCheckpointConnector(KafkaMirrorMaker2ConnectorSpec checkpointConnector);
    public Boolean hasCheckpointConnector();
    public KafkaMirrorMaker2MirrorSpecFluent.CheckpointConnectorNested<A> withNewCheckpointConnector();
    public KafkaMirrorMaker2MirrorSpecFluent.CheckpointConnectorNested<A> withNewCheckpointConnectorLike(KafkaMirrorMaker2ConnectorSpec item);
    public KafkaMirrorMaker2MirrorSpecFluent.CheckpointConnectorNested<A> editCheckpointConnector();
    public KafkaMirrorMaker2MirrorSpecFluent.CheckpointConnectorNested<A> editOrNewCheckpointConnector();
    public KafkaMirrorMaker2MirrorSpecFluent.CheckpointConnectorNested<A> editOrNewCheckpointConnectorLike(KafkaMirrorMaker2ConnectorSpec item);
    
/**
 * This method has been deprecated, please use method buildHeartbeatConnector instead.
 * @return The buildable object.
 */
@Deprecated public KafkaMirrorMaker2ConnectorSpec getHeartbeatConnector();
    public KafkaMirrorMaker2ConnectorSpec buildHeartbeatConnector();
    public A withHeartbeatConnector(KafkaMirrorMaker2ConnectorSpec heartbeatConnector);
    public Boolean hasHeartbeatConnector();
    public KafkaMirrorMaker2MirrorSpecFluent.HeartbeatConnectorNested<A> withNewHeartbeatConnector();
    public KafkaMirrorMaker2MirrorSpecFluent.HeartbeatConnectorNested<A> withNewHeartbeatConnectorLike(KafkaMirrorMaker2ConnectorSpec item);
    public KafkaMirrorMaker2MirrorSpecFluent.HeartbeatConnectorNested<A> editHeartbeatConnector();
    public KafkaMirrorMaker2MirrorSpecFluent.HeartbeatConnectorNested<A> editOrNewHeartbeatConnector();
    public KafkaMirrorMaker2MirrorSpecFluent.HeartbeatConnectorNested<A> editOrNewHeartbeatConnectorLike(KafkaMirrorMaker2ConnectorSpec item);
    public String getTopicsPattern();
    public A withTopicsPattern(String topicsPattern);
    public Boolean hasTopicsPattern();
    public A withNewTopicsPattern(String arg1);
    public A withNewTopicsPattern(StringBuilder arg1);
    public A withNewTopicsPattern(StringBuffer arg1);
    public String getTopicsBlacklistPattern();
    public A withTopicsBlacklistPattern(String topicsBlacklistPattern);
    public Boolean hasTopicsBlacklistPattern();
    public A withNewTopicsBlacklistPattern(String arg1);
    public A withNewTopicsBlacklistPattern(StringBuilder arg1);
    public A withNewTopicsBlacklistPattern(StringBuffer arg1);
    public String getGroupsPattern();
    public A withGroupsPattern(String groupsPattern);
    public Boolean hasGroupsPattern();
    public A withNewGroupsPattern(String arg1);
    public A withNewGroupsPattern(StringBuilder arg1);
    public A withNewGroupsPattern(StringBuffer arg1);
    public String getGroupsBlacklistPattern();
    public A withGroupsBlacklistPattern(String groupsBlacklistPattern);
    public Boolean hasGroupsBlacklistPattern();
    public A withNewGroupsBlacklistPattern(String arg1);
    public A withNewGroupsBlacklistPattern(StringBuilder arg1);
    public A withNewGroupsBlacklistPattern(StringBuffer arg1);

    public interface SourceConnectorNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,KafkaMirrorMaker2ConnectorSpecFluent<KafkaMirrorMaker2MirrorSpecFluent.SourceConnectorNested<N>>{

        
    public N and();    public N endSourceConnector();
}
    public interface CheckpointConnectorNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,KafkaMirrorMaker2ConnectorSpecFluent<KafkaMirrorMaker2MirrorSpecFluent.CheckpointConnectorNested<N>>{

        
    public N and();    public N endCheckpointConnector();
}
    public interface HeartbeatConnectorNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,KafkaMirrorMaker2ConnectorSpecFluent<KafkaMirrorMaker2MirrorSpecFluent.HeartbeatConnectorNested<N>>{

        
    public N and();    public N endHeartbeatConnector();
}


}
