package io.strimzi.api.kafka.model;

import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class KafkaMirrorMaker2MirrorSpecFluentImpl<A extends KafkaMirrorMaker2MirrorSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements KafkaMirrorMaker2MirrorSpecFluent<A>{

    private String sourceCluster;
    private String targetCluster;
    private KafkaMirrorMaker2ConnectorSpecBuilder sourceConnector;
    private KafkaMirrorMaker2ConnectorSpecBuilder checkpointConnector;
    private KafkaMirrorMaker2ConnectorSpecBuilder heartbeatConnector;
    private String topicsPattern;
    private String topicsBlacklistPattern;
    private String groupsPattern;
    private String groupsBlacklistPattern;

    public KafkaMirrorMaker2MirrorSpecFluentImpl(){
    }
    public KafkaMirrorMaker2MirrorSpecFluentImpl(KafkaMirrorMaker2MirrorSpec instance){
            this.withSourceCluster(instance.getSourceCluster());

            this.withTargetCluster(instance.getTargetCluster());

            this.withSourceConnector(instance.getSourceConnector());

            this.withCheckpointConnector(instance.getCheckpointConnector());

            this.withHeartbeatConnector(instance.getHeartbeatConnector());

            this.withTopicsPattern(instance.getTopicsPattern());

            this.withTopicsBlacklistPattern(instance.getTopicsBlacklistPattern());

            this.withGroupsPattern(instance.getGroupsPattern());

            this.withGroupsBlacklistPattern(instance.getGroupsBlacklistPattern());

    }

    public String getSourceCluster(){
            return this.sourceCluster;
    }

    public A withSourceCluster(String sourceCluster){
            this.sourceCluster=sourceCluster; return (A) this;
    }

    public Boolean hasSourceCluster(){
            return this.sourceCluster != null;
    }

    public A withNewSourceCluster(String arg1){
            return (A)withSourceCluster(new String(arg1));
    }

    public A withNewSourceCluster(StringBuilder arg1){
            return (A)withSourceCluster(new String(arg1));
    }

    public A withNewSourceCluster(StringBuffer arg1){
            return (A)withSourceCluster(new String(arg1));
    }

    public String getTargetCluster(){
            return this.targetCluster;
    }

    public A withTargetCluster(String targetCluster){
            this.targetCluster=targetCluster; return (A) this;
    }

    public Boolean hasTargetCluster(){
            return this.targetCluster != null;
    }

    public A withNewTargetCluster(String arg1){
            return (A)withTargetCluster(new String(arg1));
    }

    public A withNewTargetCluster(StringBuilder arg1){
            return (A)withTargetCluster(new String(arg1));
    }

    public A withNewTargetCluster(StringBuffer arg1){
            return (A)withTargetCluster(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildSourceConnector instead.
 * @return The buildable object.
 */
@Deprecated public KafkaMirrorMaker2ConnectorSpec getSourceConnector(){
            return this.sourceConnector!=null?this.sourceConnector.build():null;
    }

    public KafkaMirrorMaker2ConnectorSpec buildSourceConnector(){
            return this.sourceConnector!=null?this.sourceConnector.build():null;
    }

    public A withSourceConnector(KafkaMirrorMaker2ConnectorSpec sourceConnector){
            _visitables.get("sourceConnector").remove(this.sourceConnector);
            if (sourceConnector!=null){ this.sourceConnector= new KafkaMirrorMaker2ConnectorSpecBuilder(sourceConnector); _visitables.get("sourceConnector").add(this.sourceConnector);} return (A) this;
    }

    public Boolean hasSourceConnector(){
            return this.sourceConnector != null;
    }

    public KafkaMirrorMaker2MirrorSpecFluent.SourceConnectorNested<A> withNewSourceConnector(){
            return new SourceConnectorNestedImpl();
    }

    public KafkaMirrorMaker2MirrorSpecFluent.SourceConnectorNested<A> withNewSourceConnectorLike(KafkaMirrorMaker2ConnectorSpec item){
            return new SourceConnectorNestedImpl(item);
    }

    public KafkaMirrorMaker2MirrorSpecFluent.SourceConnectorNested<A> editSourceConnector(){
            return withNewSourceConnectorLike(getSourceConnector());
    }

    public KafkaMirrorMaker2MirrorSpecFluent.SourceConnectorNested<A> editOrNewSourceConnector(){
            return withNewSourceConnectorLike(getSourceConnector() != null ? getSourceConnector(): new KafkaMirrorMaker2ConnectorSpecBuilder().build());
    }

    public KafkaMirrorMaker2MirrorSpecFluent.SourceConnectorNested<A> editOrNewSourceConnectorLike(KafkaMirrorMaker2ConnectorSpec item){
            return withNewSourceConnectorLike(getSourceConnector() != null ? getSourceConnector(): item);
    }

    
/**
 * This method has been deprecated, please use method buildCheckpointConnector instead.
 * @return The buildable object.
 */
@Deprecated public KafkaMirrorMaker2ConnectorSpec getCheckpointConnector(){
            return this.checkpointConnector!=null?this.checkpointConnector.build():null;
    }

    public KafkaMirrorMaker2ConnectorSpec buildCheckpointConnector(){
            return this.checkpointConnector!=null?this.checkpointConnector.build():null;
    }

    public A withCheckpointConnector(KafkaMirrorMaker2ConnectorSpec checkpointConnector){
            _visitables.get("checkpointConnector").remove(this.checkpointConnector);
            if (checkpointConnector!=null){ this.checkpointConnector= new KafkaMirrorMaker2ConnectorSpecBuilder(checkpointConnector); _visitables.get("checkpointConnector").add(this.checkpointConnector);} return (A) this;
    }

    public Boolean hasCheckpointConnector(){
            return this.checkpointConnector != null;
    }

    public KafkaMirrorMaker2MirrorSpecFluent.CheckpointConnectorNested<A> withNewCheckpointConnector(){
            return new CheckpointConnectorNestedImpl();
    }

    public KafkaMirrorMaker2MirrorSpecFluent.CheckpointConnectorNested<A> withNewCheckpointConnectorLike(KafkaMirrorMaker2ConnectorSpec item){
            return new CheckpointConnectorNestedImpl(item);
    }

    public KafkaMirrorMaker2MirrorSpecFluent.CheckpointConnectorNested<A> editCheckpointConnector(){
            return withNewCheckpointConnectorLike(getCheckpointConnector());
    }

    public KafkaMirrorMaker2MirrorSpecFluent.CheckpointConnectorNested<A> editOrNewCheckpointConnector(){
            return withNewCheckpointConnectorLike(getCheckpointConnector() != null ? getCheckpointConnector(): new KafkaMirrorMaker2ConnectorSpecBuilder().build());
    }

    public KafkaMirrorMaker2MirrorSpecFluent.CheckpointConnectorNested<A> editOrNewCheckpointConnectorLike(KafkaMirrorMaker2ConnectorSpec item){
            return withNewCheckpointConnectorLike(getCheckpointConnector() != null ? getCheckpointConnector(): item);
    }

    
/**
 * This method has been deprecated, please use method buildHeartbeatConnector instead.
 * @return The buildable object.
 */
@Deprecated public KafkaMirrorMaker2ConnectorSpec getHeartbeatConnector(){
            return this.heartbeatConnector!=null?this.heartbeatConnector.build():null;
    }

    public KafkaMirrorMaker2ConnectorSpec buildHeartbeatConnector(){
            return this.heartbeatConnector!=null?this.heartbeatConnector.build():null;
    }

    public A withHeartbeatConnector(KafkaMirrorMaker2ConnectorSpec heartbeatConnector){
            _visitables.get("heartbeatConnector").remove(this.heartbeatConnector);
            if (heartbeatConnector!=null){ this.heartbeatConnector= new KafkaMirrorMaker2ConnectorSpecBuilder(heartbeatConnector); _visitables.get("heartbeatConnector").add(this.heartbeatConnector);} return (A) this;
    }

    public Boolean hasHeartbeatConnector(){
            return this.heartbeatConnector != null;
    }

    public KafkaMirrorMaker2MirrorSpecFluent.HeartbeatConnectorNested<A> withNewHeartbeatConnector(){
            return new HeartbeatConnectorNestedImpl();
    }

    public KafkaMirrorMaker2MirrorSpecFluent.HeartbeatConnectorNested<A> withNewHeartbeatConnectorLike(KafkaMirrorMaker2ConnectorSpec item){
            return new HeartbeatConnectorNestedImpl(item);
    }

    public KafkaMirrorMaker2MirrorSpecFluent.HeartbeatConnectorNested<A> editHeartbeatConnector(){
            return withNewHeartbeatConnectorLike(getHeartbeatConnector());
    }

    public KafkaMirrorMaker2MirrorSpecFluent.HeartbeatConnectorNested<A> editOrNewHeartbeatConnector(){
            return withNewHeartbeatConnectorLike(getHeartbeatConnector() != null ? getHeartbeatConnector(): new KafkaMirrorMaker2ConnectorSpecBuilder().build());
    }

    public KafkaMirrorMaker2MirrorSpecFluent.HeartbeatConnectorNested<A> editOrNewHeartbeatConnectorLike(KafkaMirrorMaker2ConnectorSpec item){
            return withNewHeartbeatConnectorLike(getHeartbeatConnector() != null ? getHeartbeatConnector(): item);
    }

    public String getTopicsPattern(){
            return this.topicsPattern;
    }

    public A withTopicsPattern(String topicsPattern){
            this.topicsPattern=topicsPattern; return (A) this;
    }

    public Boolean hasTopicsPattern(){
            return this.topicsPattern != null;
    }

    public A withNewTopicsPattern(String arg1){
            return (A)withTopicsPattern(new String(arg1));
    }

    public A withNewTopicsPattern(StringBuilder arg1){
            return (A)withTopicsPattern(new String(arg1));
    }

    public A withNewTopicsPattern(StringBuffer arg1){
            return (A)withTopicsPattern(new String(arg1));
    }

    public String getTopicsBlacklistPattern(){
            return this.topicsBlacklistPattern;
    }

    public A withTopicsBlacklistPattern(String topicsBlacklistPattern){
            this.topicsBlacklistPattern=topicsBlacklistPattern; return (A) this;
    }

    public Boolean hasTopicsBlacklistPattern(){
            return this.topicsBlacklistPattern != null;
    }

    public A withNewTopicsBlacklistPattern(String arg1){
            return (A)withTopicsBlacklistPattern(new String(arg1));
    }

    public A withNewTopicsBlacklistPattern(StringBuilder arg1){
            return (A)withTopicsBlacklistPattern(new String(arg1));
    }

    public A withNewTopicsBlacklistPattern(StringBuffer arg1){
            return (A)withTopicsBlacklistPattern(new String(arg1));
    }

    public String getGroupsPattern(){
            return this.groupsPattern;
    }

    public A withGroupsPattern(String groupsPattern){
            this.groupsPattern=groupsPattern; return (A) this;
    }

    public Boolean hasGroupsPattern(){
            return this.groupsPattern != null;
    }

    public A withNewGroupsPattern(String arg1){
            return (A)withGroupsPattern(new String(arg1));
    }

    public A withNewGroupsPattern(StringBuilder arg1){
            return (A)withGroupsPattern(new String(arg1));
    }

    public A withNewGroupsPattern(StringBuffer arg1){
            return (A)withGroupsPattern(new String(arg1));
    }

    public String getGroupsBlacklistPattern(){
            return this.groupsBlacklistPattern;
    }

    public A withGroupsBlacklistPattern(String groupsBlacklistPattern){
            this.groupsBlacklistPattern=groupsBlacklistPattern; return (A) this;
    }

    public Boolean hasGroupsBlacklistPattern(){
            return this.groupsBlacklistPattern != null;
    }

    public A withNewGroupsBlacklistPattern(String arg1){
            return (A)withGroupsBlacklistPattern(new String(arg1));
    }

    public A withNewGroupsBlacklistPattern(StringBuilder arg1){
            return (A)withGroupsBlacklistPattern(new String(arg1));
    }

    public A withNewGroupsBlacklistPattern(StringBuffer arg1){
            return (A)withGroupsBlacklistPattern(new String(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            KafkaMirrorMaker2MirrorSpecFluentImpl that = (KafkaMirrorMaker2MirrorSpecFluentImpl) o;
            if (sourceCluster != null ? !sourceCluster.equals(that.sourceCluster) :that.sourceCluster != null) return false;
            if (targetCluster != null ? !targetCluster.equals(that.targetCluster) :that.targetCluster != null) return false;
            if (sourceConnector != null ? !sourceConnector.equals(that.sourceConnector) :that.sourceConnector != null) return false;
            if (checkpointConnector != null ? !checkpointConnector.equals(that.checkpointConnector) :that.checkpointConnector != null) return false;
            if (heartbeatConnector != null ? !heartbeatConnector.equals(that.heartbeatConnector) :that.heartbeatConnector != null) return false;
            if (topicsPattern != null ? !topicsPattern.equals(that.topicsPattern) :that.topicsPattern != null) return false;
            if (topicsBlacklistPattern != null ? !topicsBlacklistPattern.equals(that.topicsBlacklistPattern) :that.topicsBlacklistPattern != null) return false;
            if (groupsPattern != null ? !groupsPattern.equals(that.groupsPattern) :that.groupsPattern != null) return false;
            if (groupsBlacklistPattern != null ? !groupsBlacklistPattern.equals(that.groupsBlacklistPattern) :that.groupsBlacklistPattern != null) return false;
            return true;
    }


    public class SourceConnectorNestedImpl<N> extends KafkaMirrorMaker2ConnectorSpecFluentImpl<KafkaMirrorMaker2MirrorSpecFluent.SourceConnectorNested<N>> implements KafkaMirrorMaker2MirrorSpecFluent.SourceConnectorNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final KafkaMirrorMaker2ConnectorSpecBuilder builder;
    
            SourceConnectorNestedImpl(KafkaMirrorMaker2ConnectorSpec item){
                    this.builder = new KafkaMirrorMaker2ConnectorSpecBuilder(this, item);
            }
            SourceConnectorNestedImpl(){
                    this.builder = new KafkaMirrorMaker2ConnectorSpecBuilder(this);
            }
    
    public N and(){
            return (N) KafkaMirrorMaker2MirrorSpecFluentImpl.this.withSourceConnector(builder.build());
    }
    public N endSourceConnector(){
            return and();
    }

}
    public class CheckpointConnectorNestedImpl<N> extends KafkaMirrorMaker2ConnectorSpecFluentImpl<KafkaMirrorMaker2MirrorSpecFluent.CheckpointConnectorNested<N>> implements KafkaMirrorMaker2MirrorSpecFluent.CheckpointConnectorNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final KafkaMirrorMaker2ConnectorSpecBuilder builder;
    
            CheckpointConnectorNestedImpl(KafkaMirrorMaker2ConnectorSpec item){
                    this.builder = new KafkaMirrorMaker2ConnectorSpecBuilder(this, item);
            }
            CheckpointConnectorNestedImpl(){
                    this.builder = new KafkaMirrorMaker2ConnectorSpecBuilder(this);
            }
    
    public N and(){
            return (N) KafkaMirrorMaker2MirrorSpecFluentImpl.this.withCheckpointConnector(builder.build());
    }
    public N endCheckpointConnector(){
            return and();
    }

}
    public class HeartbeatConnectorNestedImpl<N> extends KafkaMirrorMaker2ConnectorSpecFluentImpl<KafkaMirrorMaker2MirrorSpecFluent.HeartbeatConnectorNested<N>> implements KafkaMirrorMaker2MirrorSpecFluent.HeartbeatConnectorNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final KafkaMirrorMaker2ConnectorSpecBuilder builder;
    
            HeartbeatConnectorNestedImpl(KafkaMirrorMaker2ConnectorSpec item){
                    this.builder = new KafkaMirrorMaker2ConnectorSpecBuilder(this, item);
            }
            HeartbeatConnectorNestedImpl(){
                    this.builder = new KafkaMirrorMaker2ConnectorSpecBuilder(this);
            }
    
    public N and(){
            return (N) KafkaMirrorMaker2MirrorSpecFluentImpl.this.withHeartbeatConnector(builder.build());
    }
    public N endHeartbeatConnector(){
            return and();
    }

}


}
