package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class KafkaMirrorMaker2TlsBuilder extends KafkaMirrorMaker2TlsFluentImpl<KafkaMirrorMaker2TlsBuilder> implements VisitableBuilder<KafkaMirrorMaker2Tls,KafkaMirrorMaker2TlsBuilder>{

    KafkaMirrorMaker2TlsFluent<?> fluent;
    Boolean validationEnabled;

    public KafkaMirrorMaker2TlsBuilder(){
            this(true);
    }
    public KafkaMirrorMaker2TlsBuilder(Boolean validationEnabled){
            this(new KafkaMirrorMaker2Tls(), validationEnabled);
    }
    public KafkaMirrorMaker2TlsBuilder(KafkaMirrorMaker2TlsFluent<?> fluent){
            this(fluent, true);
    }
    public KafkaMirrorMaker2TlsBuilder(KafkaMirrorMaker2TlsFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new KafkaMirrorMaker2Tls(), validationEnabled);
    }
    public KafkaMirrorMaker2TlsBuilder(KafkaMirrorMaker2TlsFluent<?> fluent,KafkaMirrorMaker2Tls instance){
            this(fluent, instance, true);
    }
    public KafkaMirrorMaker2TlsBuilder(KafkaMirrorMaker2TlsFluent<?> fluent,KafkaMirrorMaker2Tls instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withTrustedCertificates(instance.getTrustedCertificates());

            this.validationEnabled = validationEnabled; 
    }
    public KafkaMirrorMaker2TlsBuilder(KafkaMirrorMaker2Tls instance){
            this(instance,true);
    }
    public KafkaMirrorMaker2TlsBuilder(KafkaMirrorMaker2Tls instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withTrustedCertificates(instance.getTrustedCertificates());

            this.validationEnabled = validationEnabled; 
    }

    public KafkaMirrorMaker2Tls build(){
            KafkaMirrorMaker2Tls buildable = new KafkaMirrorMaker2Tls();
            buildable.setTrustedCertificates(fluent.getTrustedCertificates());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            KafkaMirrorMaker2TlsBuilder that = (KafkaMirrorMaker2TlsBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
