package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class KafkaMirrorMakerClientSpecBuilder extends KafkaMirrorMakerClientSpecFluentImpl<KafkaMirrorMakerClientSpecBuilder> implements VisitableBuilder<KafkaMirrorMakerClientSpec,KafkaMirrorMakerClientSpecBuilder>{

    KafkaMirrorMakerClientSpecFluent<?> fluent;
    Boolean validationEnabled;

    public KafkaMirrorMakerClientSpecBuilder(){
            this(true);
    }
    public KafkaMirrorMakerClientSpecBuilder(Boolean validationEnabled){
            this(new KafkaMirrorMakerClientSpec(), validationEnabled);
    }
    public KafkaMirrorMakerClientSpecBuilder(KafkaMirrorMakerClientSpecFluent<?> fluent){
            this(fluent, true);
    }
    public KafkaMirrorMakerClientSpecBuilder(KafkaMirrorMakerClientSpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new KafkaMirrorMakerClientSpec(), validationEnabled);
    }
    public KafkaMirrorMakerClientSpecBuilder(KafkaMirrorMakerClientSpecFluent<?> fluent,KafkaMirrorMakerClientSpec instance){
            this(fluent, instance, true);
    }
    public KafkaMirrorMakerClientSpecBuilder(KafkaMirrorMakerClientSpecFluent<?> fluent,KafkaMirrorMakerClientSpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withBootstrapServers(instance.getBootstrapServers());

            fluent.withConfig(instance.getConfig());

            fluent.withTls(instance.getTls());

            fluent.withAuthentication(instance.getAuthentication());

            this.validationEnabled = validationEnabled; 
    }
    public KafkaMirrorMakerClientSpecBuilder(KafkaMirrorMakerClientSpec instance){
            this(instance,true);
    }
    public KafkaMirrorMakerClientSpecBuilder(KafkaMirrorMakerClientSpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withBootstrapServers(instance.getBootstrapServers());

            this.withConfig(instance.getConfig());

            this.withTls(instance.getTls());

            this.withAuthentication(instance.getAuthentication());

            this.validationEnabled = validationEnabled; 
    }

    public KafkaMirrorMakerClientSpec build(){
            KafkaMirrorMakerClientSpec buildable = new KafkaMirrorMakerClientSpec();
            buildable.setBootstrapServers(fluent.getBootstrapServers());
            buildable.setConfig(fluent.getConfig());
            buildable.setTls(fluent.getTls());
            buildable.setAuthentication(fluent.getAuthentication());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            KafkaMirrorMakerClientSpecBuilder that = (KafkaMirrorMakerClientSpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
