package io.strimzi.api.kafka.model;

import java.util.ArrayList;
import java.lang.String;
import io.strimzi.api.kafka.model.template.KafkaMirrorMakerTemplateBuilder;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.util.LinkedHashMap;
import io.strimzi.api.kafka.model.template.KafkaMirrorMakerTemplateFluent;
import java.util.List;
import java.lang.Boolean;
import io.strimzi.api.kafka.model.tracing.JaegerTracingFluent;
import io.fabric8.kubernetes.api.model.Toleration;
import java.lang.Long;
import io.fabric8.kubernetes.api.model.Affinity;
import java.util.Collection;
import java.lang.Object;
import io.strimzi.api.kafka.model.tracing.Tracing;
import java.util.Map;
import io.strimzi.api.kafka.model.tracing.JaegerTracingBuilder;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import io.strimzi.api.kafka.model.template.KafkaMirrorMakerTemplate;
import java.lang.Deprecated;
import io.strimzi.api.kafka.model.tracing.JaegerTracing;
import java.lang.StringBuffer;

public interface KafkaMirrorMakerSpecFluent<A extends KafkaMirrorMakerSpecFluent<A>> extends SpecFluent<A>{


    public int getReplicas();
    public A withReplicas(int replicas);
    public Boolean hasReplicas();
    public String getVersion();
    public A withVersion(String version);
    public Boolean hasVersion();
    public A withNewVersion(String arg1);
    public A withNewVersion(StringBuilder arg1);
    public A withNewVersion(StringBuffer arg1);
    public String getImage();
    public A withImage(String image);
    public Boolean hasImage();
    public A withNewImage(String arg1);
    public A withNewImage(StringBuilder arg1);
    public A withNewImage(StringBuffer arg1);
    public String getWhitelist();
    public A withWhitelist(String whitelist);
    public Boolean hasWhitelist();
    public A withNewWhitelist(String arg1);
    public A withNewWhitelist(StringBuilder arg1);
    public A withNewWhitelist(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildConsumer instead.
 * @return The buildable object.
 */
@Deprecated public KafkaMirrorMakerConsumerSpec getConsumer();
    public KafkaMirrorMakerConsumerSpec buildConsumer();
    public A withConsumer(KafkaMirrorMakerConsumerSpec consumer);
    public Boolean hasConsumer();
    public KafkaMirrorMakerSpecFluent.ConsumerNested<A> withNewConsumer();
    public KafkaMirrorMakerSpecFluent.ConsumerNested<A> withNewConsumerLike(KafkaMirrorMakerConsumerSpec item);
    public KafkaMirrorMakerSpecFluent.ConsumerNested<A> editConsumer();
    public KafkaMirrorMakerSpecFluent.ConsumerNested<A> editOrNewConsumer();
    public KafkaMirrorMakerSpecFluent.ConsumerNested<A> editOrNewConsumerLike(KafkaMirrorMakerConsumerSpec item);
    
/**
 * This method has been deprecated, please use method buildProducer instead.
 * @return The buildable object.
 */
@Deprecated public KafkaMirrorMakerProducerSpec getProducer();
    public KafkaMirrorMakerProducerSpec buildProducer();
    public A withProducer(KafkaMirrorMakerProducerSpec producer);
    public Boolean hasProducer();
    public KafkaMirrorMakerSpecFluent.ProducerNested<A> withNewProducer();
    public KafkaMirrorMakerSpecFluent.ProducerNested<A> withNewProducerLike(KafkaMirrorMakerProducerSpec item);
    public KafkaMirrorMakerSpecFluent.ProducerNested<A> editProducer();
    public KafkaMirrorMakerSpecFluent.ProducerNested<A> editOrNewProducer();
    public KafkaMirrorMakerSpecFluent.ProducerNested<A> editOrNewProducerLike(KafkaMirrorMakerProducerSpec item);
    public ResourceRequirements getResources();
    public A withResources(ResourceRequirements resources);
    public Boolean hasResources();
    
/**
 * This method has been deprecated, please use method buildLivenessProbe instead.
 * @return The buildable object.
 */
@Deprecated public Probe getLivenessProbe();
    public Probe buildLivenessProbe();
    public A withLivenessProbe(Probe livenessProbe);
    public Boolean hasLivenessProbe();
    public A withNewLivenessProbe(int initialDelaySeconds,int timeoutSeconds);
    public KafkaMirrorMakerSpecFluent.LivenessProbeNested<A> withNewLivenessProbe();
    public KafkaMirrorMakerSpecFluent.LivenessProbeNested<A> withNewLivenessProbeLike(Probe item);
    public KafkaMirrorMakerSpecFluent.LivenessProbeNested<A> editLivenessProbe();
    public KafkaMirrorMakerSpecFluent.LivenessProbeNested<A> editOrNewLivenessProbe();
    public KafkaMirrorMakerSpecFluent.LivenessProbeNested<A> editOrNewLivenessProbeLike(Probe item);
    
/**
 * This method has been deprecated, please use method buildReadinessProbe instead.
 * @return The buildable object.
 */
@Deprecated public Probe getReadinessProbe();
    public Probe buildReadinessProbe();
    public A withReadinessProbe(Probe readinessProbe);
    public Boolean hasReadinessProbe();
    public A withNewReadinessProbe(int initialDelaySeconds,int timeoutSeconds);
    public KafkaMirrorMakerSpecFluent.ReadinessProbeNested<A> withNewReadinessProbe();
    public KafkaMirrorMakerSpecFluent.ReadinessProbeNested<A> withNewReadinessProbeLike(Probe item);
    public KafkaMirrorMakerSpecFluent.ReadinessProbeNested<A> editReadinessProbe();
    public KafkaMirrorMakerSpecFluent.ReadinessProbeNested<A> editOrNewReadinessProbe();
    public KafkaMirrorMakerSpecFluent.ReadinessProbeNested<A> editOrNewReadinessProbeLike(Probe item);
    public Affinity getAffinity();
    public A withAffinity(Affinity affinity);
    public Boolean hasAffinity();
    public A addToTolerations(int index,Toleration item);
    public A setToTolerations(int index,Toleration item);
    public A addToTolerations(Toleration... items);
    public A addAllToTolerations(Collection<Toleration> items);
    public A removeFromTolerations(Toleration... items);
    public A removeAllFromTolerations(Collection<Toleration> items);
    public java.util.List<Toleration> getTolerations();
    public Toleration getToleration(int index);
    public Toleration getFirstToleration();
    public Toleration getLastToleration();
    public Toleration getMatchingToleration(io.fabric8.kubernetes.api.builder.Predicate<Toleration> predicate);
    public Boolean hasMatchingToleration(io.fabric8.kubernetes.api.builder.Predicate<Toleration> predicate);
    public A withTolerations(java.util.List<Toleration> tolerations);
    public A withTolerations(Toleration... tolerations);
    public Boolean hasTolerations();
    public A addNewToleration(String effect,String key,String operator,Long tolerationSeconds,String value);
    
/**
 * This method has been deprecated, please use method buildJvmOptions instead.
 * @return The buildable object.
 */
@Deprecated public JvmOptions getJvmOptions();
    public JvmOptions buildJvmOptions();
    public A withJvmOptions(JvmOptions jvmOptions);
    public Boolean hasJvmOptions();
    public KafkaMirrorMakerSpecFluent.JvmOptionsNested<A> withNewJvmOptions();
    public KafkaMirrorMakerSpecFluent.JvmOptionsNested<A> withNewJvmOptionsLike(JvmOptions item);
    public KafkaMirrorMakerSpecFluent.JvmOptionsNested<A> editJvmOptions();
    public KafkaMirrorMakerSpecFluent.JvmOptionsNested<A> editOrNewJvmOptions();
    public KafkaMirrorMakerSpecFluent.JvmOptionsNested<A> editOrNewJvmOptionsLike(JvmOptions item);
    
/**
 * This method has been deprecated, please use method buildLogging instead.
 * @return The buildable object.
 */
@Deprecated public Logging getLogging();
    public Logging buildLogging();
    public A withLogging(Logging logging);
    public Boolean hasLogging();
    public A withExternalLogging(ExternalLogging externalLogging);
    public KafkaMirrorMakerSpecFluent.ExternalLoggingNested<A> withNewExternalLogging();
    public KafkaMirrorMakerSpecFluent.ExternalLoggingNested<A> withNewExternalLoggingLike(ExternalLogging item);
    public A withInlineLogging(InlineLogging inlineLogging);
    public KafkaMirrorMakerSpecFluent.InlineLoggingNested<A> withNewInlineLogging();
    public KafkaMirrorMakerSpecFluent.InlineLoggingNested<A> withNewInlineLoggingLike(InlineLogging item);
    public A addToMetrics(String key,Object value);
    public A addToMetrics(Map<String,Object> map);
    public A removeFromMetrics(String key);
    public A removeFromMetrics(Map<String,Object> map);
    public Map<String,Object> getMetrics();
    public A withMetrics(Map<String,Object> metrics);
    public Boolean hasMetrics();
    
/**
 * This method has been deprecated, please use method buildMetricsConfig instead.
 * @return The buildable object.
 */
@Deprecated public MetricsConfig getMetricsConfig();
    public MetricsConfig buildMetricsConfig();
    public A withMetricsConfig(MetricsConfig metricsConfig);
    public Boolean hasMetricsConfig();
    public A withJmxPrometheusExporterMetricsConfig(JmxPrometheusExporterMetrics jmxPrometheusExporterMetricsConfig);
    public KafkaMirrorMakerSpecFluent.JmxPrometheusExporterMetricsConfigNested<A> withNewJmxPrometheusExporterMetricsConfig();
    public KafkaMirrorMakerSpecFluent.JmxPrometheusExporterMetricsConfigNested<A> withNewJmxPrometheusExporterMetricsConfigLike(JmxPrometheusExporterMetrics item);
    
/**
 * This method has been deprecated, please use method buildTracing instead.
 * @return The buildable object.
 */
@Deprecated public Tracing getTracing();
    public Tracing buildTracing();
    public A withTracing(Tracing tracing);
    public Boolean hasTracing();
    public A withJaegerTracing(JaegerTracing jaegerTracing);
    public KafkaMirrorMakerSpecFluent.JaegerTracingNested<A> withNewJaegerTracing();
    public KafkaMirrorMakerSpecFluent.JaegerTracingNested<A> withNewJaegerTracingLike(JaegerTracing item);
    
/**
 * This method has been deprecated, please use method buildTemplate instead.
 * @return The buildable object.
 */
@Deprecated public KafkaMirrorMakerTemplate getTemplate();
    public KafkaMirrorMakerTemplate buildTemplate();
    public A withTemplate(KafkaMirrorMakerTemplate template);
    public Boolean hasTemplate();
    public KafkaMirrorMakerSpecFluent.TemplateNested<A> withNewTemplate();
    public KafkaMirrorMakerSpecFluent.TemplateNested<A> withNewTemplateLike(KafkaMirrorMakerTemplate item);
    public KafkaMirrorMakerSpecFluent.TemplateNested<A> editTemplate();
    public KafkaMirrorMakerSpecFluent.TemplateNested<A> editOrNewTemplate();
    public KafkaMirrorMakerSpecFluent.TemplateNested<A> editOrNewTemplateLike(KafkaMirrorMakerTemplate item);

    public interface ConsumerNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,KafkaMirrorMakerConsumerSpecFluent<KafkaMirrorMakerSpecFluent.ConsumerNested<N>>{

        
    public N and();    public N endConsumer();
}
    public interface ProducerNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,KafkaMirrorMakerProducerSpecFluent<KafkaMirrorMakerSpecFluent.ProducerNested<N>>{

        
    public N and();    public N endProducer();
}
    public interface LivenessProbeNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ProbeFluent<KafkaMirrorMakerSpecFluent.LivenessProbeNested<N>>{

        
    public N and();    public N endLivenessProbe();
}
    public interface ReadinessProbeNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ProbeFluent<KafkaMirrorMakerSpecFluent.ReadinessProbeNested<N>>{

        
    public N and();    public N endReadinessProbe();
}
    public interface JvmOptionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,JvmOptionsFluent<KafkaMirrorMakerSpecFluent.JvmOptionsNested<N>>{

        
    public N and();    public N endJvmOptions();
}
    public interface ExternalLoggingNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ExternalLoggingFluent<KafkaMirrorMakerSpecFluent.ExternalLoggingNested<N>>{

        
    public N and();    public N endExternalLogging();
}
    public interface InlineLoggingNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,InlineLoggingFluent<KafkaMirrorMakerSpecFluent.InlineLoggingNested<N>>{

        
    public N and();    public N endInlineLogging();
}
    public interface JmxPrometheusExporterMetricsConfigNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,JmxPrometheusExporterMetricsFluent<KafkaMirrorMakerSpecFluent.JmxPrometheusExporterMetricsConfigNested<N>>{

        
    public N and();    public N endJmxPrometheusExporterMetricsConfig();
}
    public interface JaegerTracingNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,JaegerTracingFluent<KafkaMirrorMakerSpecFluent.JaegerTracingNested<N>>{

        
    public N and();    public N endJaegerTracing();
}
    public interface TemplateNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,KafkaMirrorMakerTemplateFluent<KafkaMirrorMakerSpecFluent.TemplateNested<N>>{

        
    public N and();    public N endTemplate();
}


}
