package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.ArrayList;
import java.lang.String;
import io.strimzi.api.kafka.model.template.KafkaMirrorMakerTemplateBuilder;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.util.LinkedHashMap;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.Toleration;
import java.lang.Long;
import io.fabric8.kubernetes.api.model.Affinity;
import java.util.Collection;
import java.lang.Object;
import io.strimzi.api.kafka.model.tracing.Tracing;
import java.util.Map;
import io.strimzi.api.kafka.model.tracing.JaegerTracingBuilder;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import io.strimzi.api.kafka.model.template.KafkaMirrorMakerTemplate;
import java.lang.Deprecated;
import io.strimzi.api.kafka.model.tracing.JaegerTracing;
import io.strimzi.api.kafka.model.template.KafkaMirrorMakerTemplateFluentImpl;
import java.lang.StringBuffer;
import io.strimzi.api.kafka.model.tracing.JaegerTracingFluentImpl;

public class KafkaMirrorMakerSpecFluentImpl<A extends KafkaMirrorMakerSpecFluent<A>> extends SpecFluentImpl<A> implements KafkaMirrorMakerSpecFluent<A>{

    private int replicas;
    private String version;
    private String image;
    private String whitelist;
    private KafkaMirrorMakerConsumerSpecBuilder consumer;
    private KafkaMirrorMakerProducerSpecBuilder producer;
    private ResourceRequirements resources;
    private ProbeBuilder livenessProbe;
    private ProbeBuilder readinessProbe;
    private Affinity affinity;
    private java.util.List<Toleration> tolerations;
    private JvmOptionsBuilder jvmOptions;
    private VisitableBuilder<? extends Logging,?> logging;
    private Map<String,Object> metrics;
    private VisitableBuilder<? extends MetricsConfig,?> metricsConfig;
    private VisitableBuilder<? extends Tracing,?> tracing;
    private KafkaMirrorMakerTemplateBuilder template;

    public KafkaMirrorMakerSpecFluentImpl(){
    }
    public KafkaMirrorMakerSpecFluentImpl(KafkaMirrorMakerSpec instance){
            this.withReplicas(instance.getReplicas());

            this.withVersion(instance.getVersion());

            this.withImage(instance.getImage());

            this.withWhitelist(instance.getWhitelist());

            this.withConsumer(instance.getConsumer());

            this.withProducer(instance.getProducer());

            this.withResources(instance.getResources());

            this.withLivenessProbe(instance.getLivenessProbe());

            this.withReadinessProbe(instance.getReadinessProbe());

            this.withAffinity(instance.getAffinity());

            this.withTolerations(instance.getTolerations());

            this.withJvmOptions(instance.getJvmOptions());

            this.withLogging(instance.getLogging());

            this.withMetrics(instance.getMetrics());

            this.withMetricsConfig(instance.getMetricsConfig());

            this.withTracing(instance.getTracing());

            this.withTemplate(instance.getTemplate());

    }

    public int getReplicas(){
            return this.replicas;
    }

    public A withReplicas(int replicas){
            this.replicas=replicas; return (A) this;
    }

    public Boolean hasReplicas(){
            return true;
    }

    public String getVersion(){
            return this.version;
    }

    public A withVersion(String version){
            this.version=version; return (A) this;
    }

    public Boolean hasVersion(){
            return this.version != null;
    }

    public A withNewVersion(String arg1){
            return (A)withVersion(new String(arg1));
    }

    public A withNewVersion(StringBuilder arg1){
            return (A)withVersion(new String(arg1));
    }

    public A withNewVersion(StringBuffer arg1){
            return (A)withVersion(new String(arg1));
    }

    public String getImage(){
            return this.image;
    }

    public A withImage(String image){
            this.image=image; return (A) this;
    }

    public Boolean hasImage(){
            return this.image != null;
    }

    public A withNewImage(String arg1){
            return (A)withImage(new String(arg1));
    }

    public A withNewImage(StringBuilder arg1){
            return (A)withImage(new String(arg1));
    }

    public A withNewImage(StringBuffer arg1){
            return (A)withImage(new String(arg1));
    }

    public String getWhitelist(){
            return this.whitelist;
    }

    public A withWhitelist(String whitelist){
            this.whitelist=whitelist; return (A) this;
    }

    public Boolean hasWhitelist(){
            return this.whitelist != null;
    }

    public A withNewWhitelist(String arg1){
            return (A)withWhitelist(new String(arg1));
    }

    public A withNewWhitelist(StringBuilder arg1){
            return (A)withWhitelist(new String(arg1));
    }

    public A withNewWhitelist(StringBuffer arg1){
            return (A)withWhitelist(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildConsumer instead.
 * @return The buildable object.
 */
@Deprecated public KafkaMirrorMakerConsumerSpec getConsumer(){
            return this.consumer!=null?this.consumer.build():null;
    }

    public KafkaMirrorMakerConsumerSpec buildConsumer(){
            return this.consumer!=null?this.consumer.build():null;
    }

    public A withConsumer(KafkaMirrorMakerConsumerSpec consumer){
            _visitables.get("consumer").remove(this.consumer);
            if (consumer!=null){ this.consumer= new KafkaMirrorMakerConsumerSpecBuilder(consumer); _visitables.get("consumer").add(this.consumer);} return (A) this;
    }

    public Boolean hasConsumer(){
            return this.consumer != null;
    }

    public KafkaMirrorMakerSpecFluent.ConsumerNested<A> withNewConsumer(){
            return new ConsumerNestedImpl();
    }

    public KafkaMirrorMakerSpecFluent.ConsumerNested<A> withNewConsumerLike(KafkaMirrorMakerConsumerSpec item){
            return new ConsumerNestedImpl(item);
    }

    public KafkaMirrorMakerSpecFluent.ConsumerNested<A> editConsumer(){
            return withNewConsumerLike(getConsumer());
    }

    public KafkaMirrorMakerSpecFluent.ConsumerNested<A> editOrNewConsumer(){
            return withNewConsumerLike(getConsumer() != null ? getConsumer(): new KafkaMirrorMakerConsumerSpecBuilder().build());
    }

    public KafkaMirrorMakerSpecFluent.ConsumerNested<A> editOrNewConsumerLike(KafkaMirrorMakerConsumerSpec item){
            return withNewConsumerLike(getConsumer() != null ? getConsumer(): item);
    }

    
/**
 * This method has been deprecated, please use method buildProducer instead.
 * @return The buildable object.
 */
@Deprecated public KafkaMirrorMakerProducerSpec getProducer(){
            return this.producer!=null?this.producer.build():null;
    }

    public KafkaMirrorMakerProducerSpec buildProducer(){
            return this.producer!=null?this.producer.build():null;
    }

    public A withProducer(KafkaMirrorMakerProducerSpec producer){
            _visitables.get("producer").remove(this.producer);
            if (producer!=null){ this.producer= new KafkaMirrorMakerProducerSpecBuilder(producer); _visitables.get("producer").add(this.producer);} return (A) this;
    }

    public Boolean hasProducer(){
            return this.producer != null;
    }

    public KafkaMirrorMakerSpecFluent.ProducerNested<A> withNewProducer(){
            return new ProducerNestedImpl();
    }

    public KafkaMirrorMakerSpecFluent.ProducerNested<A> withNewProducerLike(KafkaMirrorMakerProducerSpec item){
            return new ProducerNestedImpl(item);
    }

    public KafkaMirrorMakerSpecFluent.ProducerNested<A> editProducer(){
            return withNewProducerLike(getProducer());
    }

    public KafkaMirrorMakerSpecFluent.ProducerNested<A> editOrNewProducer(){
            return withNewProducerLike(getProducer() != null ? getProducer(): new KafkaMirrorMakerProducerSpecBuilder().build());
    }

    public KafkaMirrorMakerSpecFluent.ProducerNested<A> editOrNewProducerLike(KafkaMirrorMakerProducerSpec item){
            return withNewProducerLike(getProducer() != null ? getProducer(): item);
    }

    public ResourceRequirements getResources(){
            return this.resources;
    }

    public A withResources(ResourceRequirements resources){
            this.resources=resources; return (A) this;
    }

    public Boolean hasResources(){
            return this.resources != null;
    }

    
/**
 * This method has been deprecated, please use method buildLivenessProbe instead.
 * @return The buildable object.
 */
@Deprecated public Probe getLivenessProbe(){
            return this.livenessProbe!=null?this.livenessProbe.build():null;
    }

    public Probe buildLivenessProbe(){
            return this.livenessProbe!=null?this.livenessProbe.build():null;
    }

    public A withLivenessProbe(Probe livenessProbe){
            _visitables.get("livenessProbe").remove(this.livenessProbe);
            if (livenessProbe!=null){ this.livenessProbe= new ProbeBuilder(livenessProbe); _visitables.get("livenessProbe").add(this.livenessProbe);} return (A) this;
    }

    public Boolean hasLivenessProbe(){
            return this.livenessProbe != null;
    }

    public A withNewLivenessProbe(int initialDelaySeconds,int timeoutSeconds){
            return (A)withLivenessProbe(new Probe(initialDelaySeconds, timeoutSeconds));
    }

    public KafkaMirrorMakerSpecFluent.LivenessProbeNested<A> withNewLivenessProbe(){
            return new LivenessProbeNestedImpl();
    }

    public KafkaMirrorMakerSpecFluent.LivenessProbeNested<A> withNewLivenessProbeLike(Probe item){
            return new LivenessProbeNestedImpl(item);
    }

    public KafkaMirrorMakerSpecFluent.LivenessProbeNested<A> editLivenessProbe(){
            return withNewLivenessProbeLike(getLivenessProbe());
    }

    public KafkaMirrorMakerSpecFluent.LivenessProbeNested<A> editOrNewLivenessProbe(){
            return withNewLivenessProbeLike(getLivenessProbe() != null ? getLivenessProbe(): new ProbeBuilder().build());
    }

    public KafkaMirrorMakerSpecFluent.LivenessProbeNested<A> editOrNewLivenessProbeLike(Probe item){
            return withNewLivenessProbeLike(getLivenessProbe() != null ? getLivenessProbe(): item);
    }

    
/**
 * This method has been deprecated, please use method buildReadinessProbe instead.
 * @return The buildable object.
 */
@Deprecated public Probe getReadinessProbe(){
            return this.readinessProbe!=null?this.readinessProbe.build():null;
    }

    public Probe buildReadinessProbe(){
            return this.readinessProbe!=null?this.readinessProbe.build():null;
    }

    public A withReadinessProbe(Probe readinessProbe){
            _visitables.get("readinessProbe").remove(this.readinessProbe);
            if (readinessProbe!=null){ this.readinessProbe= new ProbeBuilder(readinessProbe); _visitables.get("readinessProbe").add(this.readinessProbe);} return (A) this;
    }

    public Boolean hasReadinessProbe(){
            return this.readinessProbe != null;
    }

    public A withNewReadinessProbe(int initialDelaySeconds,int timeoutSeconds){
            return (A)withReadinessProbe(new Probe(initialDelaySeconds, timeoutSeconds));
    }

    public KafkaMirrorMakerSpecFluent.ReadinessProbeNested<A> withNewReadinessProbe(){
            return new ReadinessProbeNestedImpl();
    }

    public KafkaMirrorMakerSpecFluent.ReadinessProbeNested<A> withNewReadinessProbeLike(Probe item){
            return new ReadinessProbeNestedImpl(item);
    }

    public KafkaMirrorMakerSpecFluent.ReadinessProbeNested<A> editReadinessProbe(){
            return withNewReadinessProbeLike(getReadinessProbe());
    }

    public KafkaMirrorMakerSpecFluent.ReadinessProbeNested<A> editOrNewReadinessProbe(){
            return withNewReadinessProbeLike(getReadinessProbe() != null ? getReadinessProbe(): new ProbeBuilder().build());
    }

    public KafkaMirrorMakerSpecFluent.ReadinessProbeNested<A> editOrNewReadinessProbeLike(Probe item){
            return withNewReadinessProbeLike(getReadinessProbe() != null ? getReadinessProbe(): item);
    }

    public Affinity getAffinity(){
            return this.affinity;
    }

    public A withAffinity(Affinity affinity){
            this.affinity=affinity; return (A) this;
    }

    public Boolean hasAffinity(){
            return this.affinity != null;
    }

    public A addToTolerations(int index,Toleration item){
            if (this.tolerations == null) {this.tolerations = new ArrayList<Toleration>();}
            this.tolerations.add(index, item);
            return (A)this;
    }

    public A setToTolerations(int index,Toleration item){
            if (this.tolerations == null) {this.tolerations = new ArrayList<Toleration>();}
            this.tolerations.set(index, item); return (A)this;
    }

    public A addToTolerations(Toleration... items){
            if (this.tolerations == null) {this.tolerations = new ArrayList<Toleration>();}
            for (Toleration item : items) {this.tolerations.add(item);} return (A)this;
    }

    public A addAllToTolerations(Collection<Toleration> items){
            if (this.tolerations == null) {this.tolerations = new ArrayList<Toleration>();}
            for (Toleration item : items) {this.tolerations.add(item);} return (A)this;
    }

    public A removeFromTolerations(Toleration... items){
            for (Toleration item : items) {if (this.tolerations!= null){ this.tolerations.remove(item);}} return (A)this;
    }

    public A removeAllFromTolerations(Collection<Toleration> items){
            for (Toleration item : items) {if (this.tolerations!= null){ this.tolerations.remove(item);}} return (A)this;
    }

    public java.util.List<Toleration> getTolerations(){
            return this.tolerations;
    }

    public Toleration getToleration(int index){
            return this.tolerations.get(index);
    }

    public Toleration getFirstToleration(){
            return this.tolerations.get(0);
    }

    public Toleration getLastToleration(){
            return this.tolerations.get(tolerations.size() - 1);
    }

    public Toleration getMatchingToleration(io.fabric8.kubernetes.api.builder.Predicate<Toleration> predicate){
            for (Toleration item: tolerations) { if(predicate.apply(item)){ return item;} } return null;
    }

    public Boolean hasMatchingToleration(io.fabric8.kubernetes.api.builder.Predicate<Toleration> predicate){
            for (Toleration item: tolerations) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withTolerations(java.util.List<Toleration> tolerations){
            if (this.tolerations != null) { _visitables.get("tolerations").removeAll(this.tolerations);}
            if (tolerations != null) {this.tolerations = new ArrayList<Toleration>(); for (Toleration item : tolerations){this.addToTolerations(item);}} else { this.tolerations = null;} return (A) this;
    }

    public A withTolerations(Toleration... tolerations){
            if (this.tolerations != null) {this.tolerations.clear();}
            if (tolerations != null) {for (Toleration item :tolerations){ this.addToTolerations(item);}} return (A) this;
    }

    public Boolean hasTolerations(){
            return tolerations != null && !tolerations.isEmpty();
    }

    public A addNewToleration(String effect,String key,String operator,Long tolerationSeconds,String value){
            return (A)addToTolerations(new Toleration(effect, key, operator, tolerationSeconds, value));
    }

    
/**
 * This method has been deprecated, please use method buildJvmOptions instead.
 * @return The buildable object.
 */
@Deprecated public JvmOptions getJvmOptions(){
            return this.jvmOptions!=null?this.jvmOptions.build():null;
    }

    public JvmOptions buildJvmOptions(){
            return this.jvmOptions!=null?this.jvmOptions.build():null;
    }

    public A withJvmOptions(JvmOptions jvmOptions){
            _visitables.get("jvmOptions").remove(this.jvmOptions);
            if (jvmOptions!=null){ this.jvmOptions= new JvmOptionsBuilder(jvmOptions); _visitables.get("jvmOptions").add(this.jvmOptions);} return (A) this;
    }

    public Boolean hasJvmOptions(){
            return this.jvmOptions != null;
    }

    public KafkaMirrorMakerSpecFluent.JvmOptionsNested<A> withNewJvmOptions(){
            return new JvmOptionsNestedImpl();
    }

    public KafkaMirrorMakerSpecFluent.JvmOptionsNested<A> withNewJvmOptionsLike(JvmOptions item){
            return new JvmOptionsNestedImpl(item);
    }

    public KafkaMirrorMakerSpecFluent.JvmOptionsNested<A> editJvmOptions(){
            return withNewJvmOptionsLike(getJvmOptions());
    }

    public KafkaMirrorMakerSpecFluent.JvmOptionsNested<A> editOrNewJvmOptions(){
            return withNewJvmOptionsLike(getJvmOptions() != null ? getJvmOptions(): new JvmOptionsBuilder().build());
    }

    public KafkaMirrorMakerSpecFluent.JvmOptionsNested<A> editOrNewJvmOptionsLike(JvmOptions item){
            return withNewJvmOptionsLike(getJvmOptions() != null ? getJvmOptions(): item);
    }

    
/**
 * This method has been deprecated, please use method buildLogging instead.
 * @return The buildable object.
 */
@Deprecated public Logging getLogging(){
            return this.logging!=null?this.logging.build():null;
    }

    public Logging buildLogging(){
            return this.logging!=null?this.logging.build():null;
    }

    public A withLogging(Logging logging){
            if (logging instanceof ExternalLogging){ this.logging= new ExternalLoggingBuilder((ExternalLogging)logging); _visitables.get("logging").add(this.logging);}
            if (logging instanceof InlineLogging){ this.logging= new InlineLoggingBuilder((InlineLogging)logging); _visitables.get("logging").add(this.logging);}
            return (A) this;
    }

    public Boolean hasLogging(){
            return this.logging != null;
    }

    public A withExternalLogging(ExternalLogging externalLogging){
            _visitables.get("logging").remove(this.logging);
            if (externalLogging!=null){ this.logging= new ExternalLoggingBuilder(externalLogging); _visitables.get("logging").add(this.logging);} return (A) this;
    }

    public KafkaMirrorMakerSpecFluent.ExternalLoggingNested<A> withNewExternalLogging(){
            return new ExternalLoggingNestedImpl();
    }

    public KafkaMirrorMakerSpecFluent.ExternalLoggingNested<A> withNewExternalLoggingLike(ExternalLogging item){
            return new ExternalLoggingNestedImpl(item);
    }

    public A withInlineLogging(InlineLogging inlineLogging){
            _visitables.get("logging").remove(this.logging);
            if (inlineLogging!=null){ this.logging= new InlineLoggingBuilder(inlineLogging); _visitables.get("logging").add(this.logging);} return (A) this;
    }

    public KafkaMirrorMakerSpecFluent.InlineLoggingNested<A> withNewInlineLogging(){
            return new InlineLoggingNestedImpl();
    }

    public KafkaMirrorMakerSpecFluent.InlineLoggingNested<A> withNewInlineLoggingLike(InlineLogging item){
            return new InlineLoggingNestedImpl(item);
    }

    public A addToMetrics(String key,Object value){
            if(this.metrics == null && key != null && value != null) { this.metrics = new LinkedHashMap<String,Object>(); }
            if(key != null && value != null) {this.metrics.put(key, value);} return (A)this;
    }

    public A addToMetrics(Map<String,Object> map){
            if(this.metrics == null && map != null) { this.metrics = new LinkedHashMap<String,Object>(); }
            if(map != null) { this.metrics.putAll(map);} return (A)this;
    }

    public A removeFromMetrics(String key){
            if(this.metrics == null) { return (A) this; }
            if(key != null && this.metrics != null) {this.metrics.remove(key);} return (A)this;
    }

    public A removeFromMetrics(Map<String,Object> map){
            if(this.metrics == null) { return (A) this; }
            if(map != null) { for(Object key : map.keySet()) {if (this.metrics != null){this.metrics.remove(key);}}} return (A)this;
    }

    public Map<String,Object> getMetrics(){
            return this.metrics;
    }

    public A withMetrics(Map<String,Object> metrics){
            if (metrics == null) { this.metrics =  null;} else {this.metrics = new LinkedHashMap<String,Object>(metrics);} return (A) this;
    }

    public Boolean hasMetrics(){
            return this.metrics != null;
    }

    
/**
 * This method has been deprecated, please use method buildMetricsConfig instead.
 * @return The buildable object.
 */
@Deprecated public MetricsConfig getMetricsConfig(){
            return this.metricsConfig!=null?this.metricsConfig.build():null;
    }

    public MetricsConfig buildMetricsConfig(){
            return this.metricsConfig!=null?this.metricsConfig.build():null;
    }

    public A withMetricsConfig(MetricsConfig metricsConfig){
            if (metricsConfig instanceof JmxPrometheusExporterMetrics){ this.metricsConfig= new JmxPrometheusExporterMetricsBuilder((JmxPrometheusExporterMetrics)metricsConfig); _visitables.get("metricsConfig").add(this.metricsConfig);}
            return (A) this;
    }

    public Boolean hasMetricsConfig(){
            return this.metricsConfig != null;
    }

    public A withJmxPrometheusExporterMetricsConfig(JmxPrometheusExporterMetrics jmxPrometheusExporterMetricsConfig){
            _visitables.get("metricsConfig").remove(this.metricsConfig);
            if (jmxPrometheusExporterMetricsConfig!=null){ this.metricsConfig= new JmxPrometheusExporterMetricsBuilder(jmxPrometheusExporterMetricsConfig); _visitables.get("metricsConfig").add(this.metricsConfig);} return (A) this;
    }

    public KafkaMirrorMakerSpecFluent.JmxPrometheusExporterMetricsConfigNested<A> withNewJmxPrometheusExporterMetricsConfig(){
            return new JmxPrometheusExporterMetricsConfigNestedImpl();
    }

    public KafkaMirrorMakerSpecFluent.JmxPrometheusExporterMetricsConfigNested<A> withNewJmxPrometheusExporterMetricsConfigLike(JmxPrometheusExporterMetrics item){
            return new JmxPrometheusExporterMetricsConfigNestedImpl(item);
    }

    
/**
 * This method has been deprecated, please use method buildTracing instead.
 * @return The buildable object.
 */
@Deprecated public Tracing getTracing(){
            return this.tracing!=null?this.tracing.build():null;
    }

    public Tracing buildTracing(){
            return this.tracing!=null?this.tracing.build():null;
    }

    public A withTracing(Tracing tracing){
            if (tracing instanceof JaegerTracing){ this.tracing= new JaegerTracingBuilder((JaegerTracing)tracing); _visitables.get("tracing").add(this.tracing);}
            return (A) this;
    }

    public Boolean hasTracing(){
            return this.tracing != null;
    }

    public A withJaegerTracing(JaegerTracing jaegerTracing){
            _visitables.get("tracing").remove(this.tracing);
            if (jaegerTracing!=null){ this.tracing= new JaegerTracingBuilder(jaegerTracing); _visitables.get("tracing").add(this.tracing);} return (A) this;
    }

    public KafkaMirrorMakerSpecFluent.JaegerTracingNested<A> withNewJaegerTracing(){
            return new JaegerTracingNestedImpl();
    }

    public KafkaMirrorMakerSpecFluent.JaegerTracingNested<A> withNewJaegerTracingLike(JaegerTracing item){
            return new JaegerTracingNestedImpl(item);
    }

    
/**
 * This method has been deprecated, please use method buildTemplate instead.
 * @return The buildable object.
 */
@Deprecated public KafkaMirrorMakerTemplate getTemplate(){
            return this.template!=null?this.template.build():null;
    }

    public KafkaMirrorMakerTemplate buildTemplate(){
            return this.template!=null?this.template.build():null;
    }

    public A withTemplate(KafkaMirrorMakerTemplate template){
            _visitables.get("template").remove(this.template);
            if (template!=null){ this.template= new KafkaMirrorMakerTemplateBuilder(template); _visitables.get("template").add(this.template);} return (A) this;
    }

    public Boolean hasTemplate(){
            return this.template != null;
    }

    public KafkaMirrorMakerSpecFluent.TemplateNested<A> withNewTemplate(){
            return new TemplateNestedImpl();
    }

    public KafkaMirrorMakerSpecFluent.TemplateNested<A> withNewTemplateLike(KafkaMirrorMakerTemplate item){
            return new TemplateNestedImpl(item);
    }

    public KafkaMirrorMakerSpecFluent.TemplateNested<A> editTemplate(){
            return withNewTemplateLike(getTemplate());
    }

    public KafkaMirrorMakerSpecFluent.TemplateNested<A> editOrNewTemplate(){
            return withNewTemplateLike(getTemplate() != null ? getTemplate(): new KafkaMirrorMakerTemplateBuilder().build());
    }

    public KafkaMirrorMakerSpecFluent.TemplateNested<A> editOrNewTemplateLike(KafkaMirrorMakerTemplate item){
            return withNewTemplateLike(getTemplate() != null ? getTemplate(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            KafkaMirrorMakerSpecFluentImpl that = (KafkaMirrorMakerSpecFluentImpl) o;
            if (replicas != that.replicas) return false;
            if (version != null ? !version.equals(that.version) :that.version != null) return false;
            if (image != null ? !image.equals(that.image) :that.image != null) return false;
            if (whitelist != null ? !whitelist.equals(that.whitelist) :that.whitelist != null) return false;
            if (consumer != null ? !consumer.equals(that.consumer) :that.consumer != null) return false;
            if (producer != null ? !producer.equals(that.producer) :that.producer != null) return false;
            if (resources != null ? !resources.equals(that.resources) :that.resources != null) return false;
            if (livenessProbe != null ? !livenessProbe.equals(that.livenessProbe) :that.livenessProbe != null) return false;
            if (readinessProbe != null ? !readinessProbe.equals(that.readinessProbe) :that.readinessProbe != null) return false;
            if (affinity != null ? !affinity.equals(that.affinity) :that.affinity != null) return false;
            if (tolerations != null ? !tolerations.equals(that.tolerations) :that.tolerations != null) return false;
            if (jvmOptions != null ? !jvmOptions.equals(that.jvmOptions) :that.jvmOptions != null) return false;
            if (logging != null ? !logging.equals(that.logging) :that.logging != null) return false;
            if (metrics != null ? !metrics.equals(that.metrics) :that.metrics != null) return false;
            if (metricsConfig != null ? !metricsConfig.equals(that.metricsConfig) :that.metricsConfig != null) return false;
            if (tracing != null ? !tracing.equals(that.tracing) :that.tracing != null) return false;
            if (template != null ? !template.equals(that.template) :that.template != null) return false;
            return true;
    }


    public class ConsumerNestedImpl<N> extends KafkaMirrorMakerConsumerSpecFluentImpl<KafkaMirrorMakerSpecFluent.ConsumerNested<N>> implements KafkaMirrorMakerSpecFluent.ConsumerNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final KafkaMirrorMakerConsumerSpecBuilder builder;
    
            ConsumerNestedImpl(KafkaMirrorMakerConsumerSpec item){
                    this.builder = new KafkaMirrorMakerConsumerSpecBuilder(this, item);
            }
            ConsumerNestedImpl(){
                    this.builder = new KafkaMirrorMakerConsumerSpecBuilder(this);
            }
    
    public N and(){
            return (N) KafkaMirrorMakerSpecFluentImpl.this.withConsumer(builder.build());
    }
    public N endConsumer(){
            return and();
    }

}
    public class ProducerNestedImpl<N> extends KafkaMirrorMakerProducerSpecFluentImpl<KafkaMirrorMakerSpecFluent.ProducerNested<N>> implements KafkaMirrorMakerSpecFluent.ProducerNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final KafkaMirrorMakerProducerSpecBuilder builder;
    
            ProducerNestedImpl(KafkaMirrorMakerProducerSpec item){
                    this.builder = new KafkaMirrorMakerProducerSpecBuilder(this, item);
            }
            ProducerNestedImpl(){
                    this.builder = new KafkaMirrorMakerProducerSpecBuilder(this);
            }
    
    public N and(){
            return (N) KafkaMirrorMakerSpecFluentImpl.this.withProducer(builder.build());
    }
    public N endProducer(){
            return and();
    }

}
    public class LivenessProbeNestedImpl<N> extends ProbeFluentImpl<KafkaMirrorMakerSpecFluent.LivenessProbeNested<N>> implements KafkaMirrorMakerSpecFluent.LivenessProbeNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ProbeBuilder builder;
    
            LivenessProbeNestedImpl(Probe item){
                    this.builder = new ProbeBuilder(this, item);
            }
            LivenessProbeNestedImpl(){
                    this.builder = new ProbeBuilder(this);
            }
    
    public N and(){
            return (N) KafkaMirrorMakerSpecFluentImpl.this.withLivenessProbe(builder.build());
    }
    public N endLivenessProbe(){
            return and();
    }

}
    public class ReadinessProbeNestedImpl<N> extends ProbeFluentImpl<KafkaMirrorMakerSpecFluent.ReadinessProbeNested<N>> implements KafkaMirrorMakerSpecFluent.ReadinessProbeNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ProbeBuilder builder;
    
            ReadinessProbeNestedImpl(Probe item){
                    this.builder = new ProbeBuilder(this, item);
            }
            ReadinessProbeNestedImpl(){
                    this.builder = new ProbeBuilder(this);
            }
    
    public N and(){
            return (N) KafkaMirrorMakerSpecFluentImpl.this.withReadinessProbe(builder.build());
    }
    public N endReadinessProbe(){
            return and();
    }

}
    public class JvmOptionsNestedImpl<N> extends JvmOptionsFluentImpl<KafkaMirrorMakerSpecFluent.JvmOptionsNested<N>> implements KafkaMirrorMakerSpecFluent.JvmOptionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final JvmOptionsBuilder builder;
    
            JvmOptionsNestedImpl(JvmOptions item){
                    this.builder = new JvmOptionsBuilder(this, item);
            }
            JvmOptionsNestedImpl(){
                    this.builder = new JvmOptionsBuilder(this);
            }
    
    public N and(){
            return (N) KafkaMirrorMakerSpecFluentImpl.this.withJvmOptions(builder.build());
    }
    public N endJvmOptions(){
            return and();
    }

}
    public class ExternalLoggingNestedImpl<N> extends ExternalLoggingFluentImpl<KafkaMirrorMakerSpecFluent.ExternalLoggingNested<N>> implements KafkaMirrorMakerSpecFluent.ExternalLoggingNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ExternalLoggingBuilder builder;
    
            ExternalLoggingNestedImpl(ExternalLogging item){
                    this.builder = new ExternalLoggingBuilder(this, item);
            }
            ExternalLoggingNestedImpl(){
                    this.builder = new ExternalLoggingBuilder(this);
            }
    
    public N and(){
            return (N) KafkaMirrorMakerSpecFluentImpl.this.withExternalLogging(builder.build());
    }
    public N endExternalLogging(){
            return and();
    }

}
    public class InlineLoggingNestedImpl<N> extends InlineLoggingFluentImpl<KafkaMirrorMakerSpecFluent.InlineLoggingNested<N>> implements KafkaMirrorMakerSpecFluent.InlineLoggingNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final InlineLoggingBuilder builder;
    
            InlineLoggingNestedImpl(InlineLogging item){
                    this.builder = new InlineLoggingBuilder(this, item);
            }
            InlineLoggingNestedImpl(){
                    this.builder = new InlineLoggingBuilder(this);
            }
    
    public N and(){
            return (N) KafkaMirrorMakerSpecFluentImpl.this.withInlineLogging(builder.build());
    }
    public N endInlineLogging(){
            return and();
    }

}
    public class JmxPrometheusExporterMetricsConfigNestedImpl<N> extends JmxPrometheusExporterMetricsFluentImpl<KafkaMirrorMakerSpecFluent.JmxPrometheusExporterMetricsConfigNested<N>> implements KafkaMirrorMakerSpecFluent.JmxPrometheusExporterMetricsConfigNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final JmxPrometheusExporterMetricsBuilder builder;
    
            JmxPrometheusExporterMetricsConfigNestedImpl(JmxPrometheusExporterMetrics item){
                    this.builder = new JmxPrometheusExporterMetricsBuilder(this, item);
            }
            JmxPrometheusExporterMetricsConfigNestedImpl(){
                    this.builder = new JmxPrometheusExporterMetricsBuilder(this);
            }
    
    public N and(){
            return (N) KafkaMirrorMakerSpecFluentImpl.this.withJmxPrometheusExporterMetricsConfig(builder.build());
    }
    public N endJmxPrometheusExporterMetricsConfig(){
            return and();
    }

}
    public class JaegerTracingNestedImpl<N> extends JaegerTracingFluentImpl<KafkaMirrorMakerSpecFluent.JaegerTracingNested<N>> implements KafkaMirrorMakerSpecFluent.JaegerTracingNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final JaegerTracingBuilder builder;
    
            JaegerTracingNestedImpl(JaegerTracing item){
                    this.builder = new JaegerTracingBuilder(this, item);
            }
            JaegerTracingNestedImpl(){
                    this.builder = new JaegerTracingBuilder(this);
            }
    
    public N and(){
            return (N) KafkaMirrorMakerSpecFluentImpl.this.withJaegerTracing(builder.build());
    }
    public N endJaegerTracing(){
            return and();
    }

}
    public class TemplateNestedImpl<N> extends KafkaMirrorMakerTemplateFluentImpl<KafkaMirrorMakerSpecFluent.TemplateNested<N>> implements KafkaMirrorMakerSpecFluent.TemplateNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final KafkaMirrorMakerTemplateBuilder builder;
    
            TemplateNestedImpl(KafkaMirrorMakerTemplate item){
                    this.builder = new KafkaMirrorMakerTemplateBuilder(this, item);
            }
            TemplateNestedImpl(){
                    this.builder = new KafkaMirrorMakerTemplateBuilder(this);
            }
    
    public N and(){
            return (N) KafkaMirrorMakerSpecFluentImpl.this.withTemplate(builder.build());
    }
    public N endTemplate(){
            return and();
    }

}


}
