package io.strimzi.api.kafka.model;

import io.strimzi.api.kafka.model.status.KafkaTopicStatus;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import java.lang.StringBuilder;
import io.strimzi.api.kafka.model.status.KafkaTopicStatusBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.strimzi.api.kafka.model.status.KafkaTopicStatusFluent;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.lang.Deprecated;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface KafkaTopicFluent<A extends KafkaTopicFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public ObjectMeta getMetadata();
    public ObjectMeta buildMetadata();
    public A withMetadata(ObjectMeta metadata);
    public Boolean hasMetadata();
    public KafkaTopicFluent.MetadataNested<A> withNewMetadata();
    public KafkaTopicFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public KafkaTopicFluent.MetadataNested<A> editMetadata();
    public KafkaTopicFluent.MetadataNested<A> editOrNewMetadata();
    public KafkaTopicFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
    
/**
 * This method has been deprecated, please use method buildSpec instead.
 * @return The buildable object.
 */
@Deprecated public KafkaTopicSpec getSpec();
    public KafkaTopicSpec buildSpec();
    public A withSpec(KafkaTopicSpec spec);
    public Boolean hasSpec();
    public KafkaTopicFluent.SpecNested<A> withNewSpec();
    public KafkaTopicFluent.SpecNested<A> withNewSpecLike(KafkaTopicSpec item);
    public KafkaTopicFluent.SpecNested<A> editSpec();
    public KafkaTopicFluent.SpecNested<A> editOrNewSpec();
    public KafkaTopicFluent.SpecNested<A> editOrNewSpecLike(KafkaTopicSpec item);
    
/**
 * This method has been deprecated, please use method buildStatus instead.
 * @return The buildable object.
 */
@Deprecated public KafkaTopicStatus getStatus();
    public KafkaTopicStatus buildStatus();
    public A withStatus(KafkaTopicStatus status);
    public Boolean hasStatus();
    public KafkaTopicFluent.StatusNested<A> withNewStatus();
    public KafkaTopicFluent.StatusNested<A> withNewStatusLike(KafkaTopicStatus item);
    public KafkaTopicFluent.StatusNested<A> editStatus();
    public KafkaTopicFluent.StatusNested<A> editOrNewStatus();
    public KafkaTopicFluent.StatusNested<A> editOrNewStatusLike(KafkaTopicStatus item);

    public interface MetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ObjectMetaFluent<KafkaTopicFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}
    public interface SpecNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,KafkaTopicSpecFluent<KafkaTopicFluent.SpecNested<N>>{

        
    public N and();    public N endSpec();
}
    public interface StatusNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,KafkaTopicStatusFluent<KafkaTopicFluent.StatusNested<N>>{

        
    public N and();    public N endStatus();
}


}
