package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.Collection;
import java.util.List;
import java.lang.Boolean;

public interface KafkaUserAuthorizationSimpleFluent<A extends KafkaUserAuthorizationSimpleFluent<A>> extends Fluent<A>{


    public A addToAcls(int index,AclRule item);
    public A setToAcls(int index,AclRule item);
    public A addToAcls(AclRule... items);
    public A addAllToAcls(Collection<AclRule> items);
    public A removeFromAcls(AclRule... items);
    public A removeAllFromAcls(Collection<AclRule> items);
    public A removeMatchingFromAcls(io.fabric8.kubernetes.api.builder.Predicate<AclRuleBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildAcls instead.
 * @return The buildable object.
 */
@Deprecated public java.util.List<AclRule> getAcls();
    public java.util.List<AclRule> buildAcls();
    public AclRule buildAcl(int index);
    public AclRule buildFirstAcl();
    public AclRule buildLastAcl();
    public AclRule buildMatchingAcl(io.fabric8.kubernetes.api.builder.Predicate<AclRuleBuilder> predicate);
    public Boolean hasMatchingAcl(io.fabric8.kubernetes.api.builder.Predicate<AclRuleBuilder> predicate);
    public A withAcls(java.util.List<AclRule> acls);
    public A withAcls(AclRule... acls);
    public Boolean hasAcls();
    public KafkaUserAuthorizationSimpleFluent.AclsNested<A> addNewAcl();
    public KafkaUserAuthorizationSimpleFluent.AclsNested<A> addNewAclLike(AclRule item);
    public KafkaUserAuthorizationSimpleFluent.AclsNested<A> setNewAclLike(int index,AclRule item);
    public KafkaUserAuthorizationSimpleFluent.AclsNested<A> editAcl(int index);
    public KafkaUserAuthorizationSimpleFluent.AclsNested<A> editFirstAcl();
    public KafkaUserAuthorizationSimpleFluent.AclsNested<A> editLastAcl();
    public KafkaUserAuthorizationSimpleFluent.AclsNested<A> editMatchingAcl(io.fabric8.kubernetes.api.builder.Predicate<AclRuleBuilder> predicate);

    public interface AclsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,AclRuleFluent<KafkaUserAuthorizationSimpleFluent.AclsNested<N>>{

        
    public N and();    public N endAcl();
}


}
