package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class KafkaUserQuotasBuilder extends KafkaUserQuotasFluentImpl<KafkaUserQuotasBuilder> implements VisitableBuilder<KafkaUserQuotas,KafkaUserQuotasBuilder>{

    KafkaUserQuotasFluent<?> fluent;
    Boolean validationEnabled;

    public KafkaUserQuotasBuilder(){
            this(true);
    }
    public KafkaUserQuotasBuilder(Boolean validationEnabled){
            this(new KafkaUserQuotas(), validationEnabled);
    }
    public KafkaUserQuotasBuilder(KafkaUserQuotasFluent<?> fluent){
            this(fluent, true);
    }
    public KafkaUserQuotasBuilder(KafkaUserQuotasFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new KafkaUserQuotas(), validationEnabled);
    }
    public KafkaUserQuotasBuilder(KafkaUserQuotasFluent<?> fluent,KafkaUserQuotas instance){
            this(fluent, instance, true);
    }
    public KafkaUserQuotasBuilder(KafkaUserQuotasFluent<?> fluent,KafkaUserQuotas instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withProducerByteRate(instance.getProducerByteRate());

            fluent.withConsumerByteRate(instance.getConsumerByteRate());

            fluent.withRequestPercentage(instance.getRequestPercentage());

            this.validationEnabled = validationEnabled; 
    }
    public KafkaUserQuotasBuilder(KafkaUserQuotas instance){
            this(instance,true);
    }
    public KafkaUserQuotasBuilder(KafkaUserQuotas instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withProducerByteRate(instance.getProducerByteRate());

            this.withConsumerByteRate(instance.getConsumerByteRate());

            this.withRequestPercentage(instance.getRequestPercentage());

            this.validationEnabled = validationEnabled; 
    }

    public KafkaUserQuotas build(){
            KafkaUserQuotas buildable = new KafkaUserQuotas();
            buildable.setProducerByteRate(fluent.getProducerByteRate());
            buildable.setConsumerByteRate(fluent.getConsumerByteRate());
            buildable.setRequestPercentage(fluent.getRequestPercentage());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            KafkaUserQuotasBuilder that = (KafkaUserQuotasBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
