package io.strimzi.api.kafka.model;

import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;
import java.util.Map;

public interface KafkaUserQuotasFluent<A extends KafkaUserQuotasFluent<A>> extends Fluent<A>{


    public Integer getProducerByteRate();
    public A withProducerByteRate(Integer producerByteRate);
    public Boolean hasProducerByteRate();
    public Integer getConsumerByteRate();
    public A withConsumerByteRate(Integer consumerByteRate);
    public Boolean hasConsumerByteRate();
    public Integer getRequestPercentage();
    public A withRequestPercentage(Integer requestPercentage);
    public Boolean hasRequestPercentage();



}
