package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class KafkaUserSpecBuilder extends KafkaUserSpecFluentImpl<KafkaUserSpecBuilder> implements VisitableBuilder<KafkaUserSpec,KafkaUserSpecBuilder>{

    KafkaUserSpecFluent<?> fluent;
    Boolean validationEnabled;

    public KafkaUserSpecBuilder(){
            this(true);
    }
    public KafkaUserSpecBuilder(Boolean validationEnabled){
            this(new KafkaUserSpec(), validationEnabled);
    }
    public KafkaUserSpecBuilder(KafkaUserSpecFluent<?> fluent){
            this(fluent, true);
    }
    public KafkaUserSpecBuilder(KafkaUserSpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new KafkaUserSpec(), validationEnabled);
    }
    public KafkaUserSpecBuilder(KafkaUserSpecFluent<?> fluent,KafkaUserSpec instance){
            this(fluent, instance, true);
    }
    public KafkaUserSpecBuilder(KafkaUserSpecFluent<?> fluent,KafkaUserSpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withAuthentication(instance.getAuthentication());

            fluent.withAuthorization(instance.getAuthorization());

            fluent.withQuotas(instance.getQuotas());

            fluent.withTemplate(instance.getTemplate());

            this.validationEnabled = validationEnabled; 
    }
    public KafkaUserSpecBuilder(KafkaUserSpec instance){
            this(instance,true);
    }
    public KafkaUserSpecBuilder(KafkaUserSpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withAuthentication(instance.getAuthentication());

            this.withAuthorization(instance.getAuthorization());

            this.withQuotas(instance.getQuotas());

            this.withTemplate(instance.getTemplate());

            this.validationEnabled = validationEnabled; 
    }

    public KafkaUserSpec build(){
            KafkaUserSpec buildable = new KafkaUserSpec();
            buildable.setAuthentication(fluent.getAuthentication());
            buildable.setAuthorization(fluent.getAuthorization());
            buildable.setQuotas(fluent.getQuotas());
            buildable.setTemplate(fluent.getTemplate());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            KafkaUserSpecBuilder that = (KafkaUserSpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
