package io.strimzi.api.kafka.model;

import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;
import java.util.Map;

public interface ProbeFluent<A extends ProbeFluent<A>> extends Fluent<A>{


    public int getInitialDelaySeconds();
    public A withInitialDelaySeconds(int initialDelaySeconds);
    public Boolean hasInitialDelaySeconds();
    public int getTimeoutSeconds();
    public A withTimeoutSeconds(int timeoutSeconds);
    public Boolean hasTimeoutSeconds();
    public Integer getPeriodSeconds();
    public A withPeriodSeconds(Integer periodSeconds);
    public Boolean hasPeriodSeconds();
    public Integer getSuccessThreshold();
    public A withSuccessThreshold(Integer successThreshold);
    public Boolean hasSuccessThreshold();
    public Integer getFailureThreshold();
    public A withFailureThreshold(Integer failureThreshold);
    public Boolean hasFailureThreshold();



}
