package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class TopicOperatorSpecBuilder extends TopicOperatorSpecFluentImpl<TopicOperatorSpecBuilder> implements VisitableBuilder<TopicOperatorSpec,TopicOperatorSpecBuilder>{

    TopicOperatorSpecFluent<?> fluent;
    Boolean validationEnabled;

    public TopicOperatorSpecBuilder(){
            this(true);
    }
    public TopicOperatorSpecBuilder(Boolean validationEnabled){
            this(new TopicOperatorSpec(), validationEnabled);
    }
    public TopicOperatorSpecBuilder(TopicOperatorSpecFluent<?> fluent){
            this(fluent, true);
    }
    public TopicOperatorSpecBuilder(TopicOperatorSpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new TopicOperatorSpec(), validationEnabled);
    }
    public TopicOperatorSpecBuilder(TopicOperatorSpecFluent<?> fluent,TopicOperatorSpec instance){
            this(fluent, instance, true);
    }
    public TopicOperatorSpecBuilder(TopicOperatorSpecFluent<?> fluent,TopicOperatorSpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withAffinity(instance.getAffinity());

            fluent.withTlsSidecar(instance.getTlsSidecar());

            fluent.withWatchedNamespace(instance.getWatchedNamespace());

            fluent.withImage(instance.getImage());

            fluent.withReconciliationIntervalSeconds(instance.getReconciliationIntervalSeconds());

            fluent.withZookeeperSessionTimeoutSeconds(instance.getZookeeperSessionTimeoutSeconds());

            fluent.withTopicMetadataMaxAttempts(instance.getTopicMetadataMaxAttempts());

            fluent.withLivenessProbe(instance.getLivenessProbe());

            fluent.withReadinessProbe(instance.getReadinessProbe());

            fluent.withResources(instance.getResources());

            fluent.withLogging(instance.getLogging());

            fluent.withJvmOptions(instance.getJvmOptions());

            this.validationEnabled = validationEnabled; 
    }
    public TopicOperatorSpecBuilder(TopicOperatorSpec instance){
            this(instance,true);
    }
    public TopicOperatorSpecBuilder(TopicOperatorSpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withAffinity(instance.getAffinity());

            this.withTlsSidecar(instance.getTlsSidecar());

            this.withWatchedNamespace(instance.getWatchedNamespace());

            this.withImage(instance.getImage());

            this.withReconciliationIntervalSeconds(instance.getReconciliationIntervalSeconds());

            this.withZookeeperSessionTimeoutSeconds(instance.getZookeeperSessionTimeoutSeconds());

            this.withTopicMetadataMaxAttempts(instance.getTopicMetadataMaxAttempts());

            this.withLivenessProbe(instance.getLivenessProbe());

            this.withReadinessProbe(instance.getReadinessProbe());

            this.withResources(instance.getResources());

            this.withLogging(instance.getLogging());

            this.withJvmOptions(instance.getJvmOptions());

            this.validationEnabled = validationEnabled; 
    }

    public TopicOperatorSpec build(){
            TopicOperatorSpec buildable = new TopicOperatorSpec();
            buildable.setWatchedNamespace(fluent.getWatchedNamespace());
            buildable.setImage(fluent.getImage());
            buildable.setReconciliationIntervalSeconds(fluent.getReconciliationIntervalSeconds());
            buildable.setZookeeperSessionTimeoutSeconds(fluent.getZookeeperSessionTimeoutSeconds());
            buildable.setTopicMetadataMaxAttempts(fluent.getTopicMetadataMaxAttempts());
            buildable.setLivenessProbe(fluent.getLivenessProbe());
            buildable.setReadinessProbe(fluent.getReadinessProbe());
            buildable.setResources(fluent.getResources());
            buildable.setLogging(fluent.getLogging());
            buildable.setJvmOptions(fluent.getJvmOptions());
            buildable.setAffinity(fluent.getAffinity());
            buildable.setTlsSidecar(fluent.getTlsSidecar());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            TopicOperatorSpecBuilder that = (TopicOperatorSpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
