package io.strimzi.api.kafka.model.authentication;

import io.strimzi.api.kafka.model.GenericSecretSource;
import io.strimzi.api.kafka.model.GenericSecretSourceBuilder;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import io.strimzi.api.kafka.model.GenericSecretSourceFluent;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.StringBuffer;
import io.strimzi.api.kafka.model.CertSecretSourceBuilder;
import io.strimzi.api.kafka.model.CertSecretSourceFluent;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.Collection;
import java.util.List;
import java.lang.Boolean;
import io.strimzi.api.kafka.model.CertSecretSource;

public interface KafkaClientAuthenticationOAuthFluent<A extends KafkaClientAuthenticationOAuthFluent<A>> extends Fluent<A>{


    public String getClientId();
    public A withClientId(String clientId);
    public Boolean hasClientId();
    public A withNewClientId(String arg1);
    public A withNewClientId(StringBuilder arg1);
    public A withNewClientId(StringBuffer arg1);
    public String getScope();
    public A withScope(String scope);
    public Boolean hasScope();
    public A withNewScope(String arg1);
    public A withNewScope(StringBuilder arg1);
    public A withNewScope(StringBuffer arg1);
    public String getTokenEndpointUri();
    public A withTokenEndpointUri(String tokenEndpointUri);
    public Boolean hasTokenEndpointUri();
    public A withNewTokenEndpointUri(String arg1);
    public A withNewTokenEndpointUri(StringBuilder arg1);
    public A withNewTokenEndpointUri(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildClientSecret instead.
 * @return The buildable object.
 */
@Deprecated public GenericSecretSource getClientSecret();
    public GenericSecretSource buildClientSecret();
    public A withClientSecret(GenericSecretSource clientSecret);
    public Boolean hasClientSecret();
    public KafkaClientAuthenticationOAuthFluent.ClientSecretNested<A> withNewClientSecret();
    public KafkaClientAuthenticationOAuthFluent.ClientSecretNested<A> withNewClientSecretLike(GenericSecretSource item);
    public KafkaClientAuthenticationOAuthFluent.ClientSecretNested<A> editClientSecret();
    public KafkaClientAuthenticationOAuthFluent.ClientSecretNested<A> editOrNewClientSecret();
    public KafkaClientAuthenticationOAuthFluent.ClientSecretNested<A> editOrNewClientSecretLike(GenericSecretSource item);
    
/**
 * This method has been deprecated, please use method buildAccessToken instead.
 * @return The buildable object.
 */
@Deprecated public GenericSecretSource getAccessToken();
    public GenericSecretSource buildAccessToken();
    public A withAccessToken(GenericSecretSource accessToken);
    public Boolean hasAccessToken();
    public KafkaClientAuthenticationOAuthFluent.AccessTokenNested<A> withNewAccessToken();
    public KafkaClientAuthenticationOAuthFluent.AccessTokenNested<A> withNewAccessTokenLike(GenericSecretSource item);
    public KafkaClientAuthenticationOAuthFluent.AccessTokenNested<A> editAccessToken();
    public KafkaClientAuthenticationOAuthFluent.AccessTokenNested<A> editOrNewAccessToken();
    public KafkaClientAuthenticationOAuthFluent.AccessTokenNested<A> editOrNewAccessTokenLike(GenericSecretSource item);
    
/**
 * This method has been deprecated, please use method buildRefreshToken instead.
 * @return The buildable object.
 */
@Deprecated public GenericSecretSource getRefreshToken();
    public GenericSecretSource buildRefreshToken();
    public A withRefreshToken(GenericSecretSource refreshToken);
    public Boolean hasRefreshToken();
    public KafkaClientAuthenticationOAuthFluent.RefreshTokenNested<A> withNewRefreshToken();
    public KafkaClientAuthenticationOAuthFluent.RefreshTokenNested<A> withNewRefreshTokenLike(GenericSecretSource item);
    public KafkaClientAuthenticationOAuthFluent.RefreshTokenNested<A> editRefreshToken();
    public KafkaClientAuthenticationOAuthFluent.RefreshTokenNested<A> editOrNewRefreshToken();
    public KafkaClientAuthenticationOAuthFluent.RefreshTokenNested<A> editOrNewRefreshTokenLike(GenericSecretSource item);
    public A addToTlsTrustedCertificates(int index,CertSecretSource item);
    public A setToTlsTrustedCertificates(int index,CertSecretSource item);
    public A addToTlsTrustedCertificates(CertSecretSource... items);
    public A addAllToTlsTrustedCertificates(Collection<CertSecretSource> items);
    public A removeFromTlsTrustedCertificates(CertSecretSource... items);
    public A removeAllFromTlsTrustedCertificates(Collection<CertSecretSource> items);
    public A removeMatchingFromTlsTrustedCertificates(io.fabric8.kubernetes.api.builder.Predicate<CertSecretSourceBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildTlsTrustedCertificates instead.
 * @return The buildable object.
 */
@Deprecated public java.util.List<CertSecretSource> getTlsTrustedCertificates();
    public java.util.List<CertSecretSource> buildTlsTrustedCertificates();
    public CertSecretSource buildTlsTrustedCertificate(int index);
    public CertSecretSource buildFirstTlsTrustedCertificate();
    public CertSecretSource buildLastTlsTrustedCertificate();
    public CertSecretSource buildMatchingTlsTrustedCertificate(io.fabric8.kubernetes.api.builder.Predicate<CertSecretSourceBuilder> predicate);
    public Boolean hasMatchingTlsTrustedCertificate(io.fabric8.kubernetes.api.builder.Predicate<CertSecretSourceBuilder> predicate);
    public A withTlsTrustedCertificates(java.util.List<CertSecretSource> tlsTrustedCertificates);
    public A withTlsTrustedCertificates(CertSecretSource... tlsTrustedCertificates);
    public Boolean hasTlsTrustedCertificates();
    public KafkaClientAuthenticationOAuthFluent.TlsTrustedCertificatesNested<A> addNewTlsTrustedCertificate();
    public KafkaClientAuthenticationOAuthFluent.TlsTrustedCertificatesNested<A> addNewTlsTrustedCertificateLike(CertSecretSource item);
    public KafkaClientAuthenticationOAuthFluent.TlsTrustedCertificatesNested<A> setNewTlsTrustedCertificateLike(int index,CertSecretSource item);
    public KafkaClientAuthenticationOAuthFluent.TlsTrustedCertificatesNested<A> editTlsTrustedCertificate(int index);
    public KafkaClientAuthenticationOAuthFluent.TlsTrustedCertificatesNested<A> editFirstTlsTrustedCertificate();
    public KafkaClientAuthenticationOAuthFluent.TlsTrustedCertificatesNested<A> editLastTlsTrustedCertificate();
    public KafkaClientAuthenticationOAuthFluent.TlsTrustedCertificatesNested<A> editMatchingTlsTrustedCertificate(io.fabric8.kubernetes.api.builder.Predicate<CertSecretSourceBuilder> predicate);
    public boolean isDisableTlsHostnameVerification();
    public A withDisableTlsHostnameVerification(boolean disableTlsHostnameVerification);
    public Boolean hasDisableTlsHostnameVerification();
    public int getMaxTokenExpirySeconds();
    public A withMaxTokenExpirySeconds(int maxTokenExpirySeconds);
    public Boolean hasMaxTokenExpirySeconds();
    public boolean isAccessTokenIsJwt();
    public A withAccessTokenIsJwt(boolean accessTokenIsJwt);
    public Boolean hasAccessTokenIsJwt();

    public interface ClientSecretNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,GenericSecretSourceFluent<KafkaClientAuthenticationOAuthFluent.ClientSecretNested<N>>{

        
    public N and();    public N endClientSecret();
}
    public interface AccessTokenNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,GenericSecretSourceFluent<KafkaClientAuthenticationOAuthFluent.AccessTokenNested<N>>{

        
    public N and();    public N endAccessToken();
}
    public interface RefreshTokenNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,GenericSecretSourceFluent<KafkaClientAuthenticationOAuthFluent.RefreshTokenNested<N>>{

        
    public N and();    public N endRefreshToken();
}
    public interface TlsTrustedCertificatesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,CertSecretSourceFluent<KafkaClientAuthenticationOAuthFluent.TlsTrustedCertificatesNested<N>>{

        
    public N and();    public N endTlsTrustedCertificate();
}


}
