package io.strimzi.api.kafka.model.authentication;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class KafkaClientAuthenticationTlsBuilder extends KafkaClientAuthenticationTlsFluentImpl<KafkaClientAuthenticationTlsBuilder> implements VisitableBuilder<KafkaClientAuthenticationTls,KafkaClientAuthenticationTlsBuilder>{

    KafkaClientAuthenticationTlsFluent<?> fluent;
    Boolean validationEnabled;

    public KafkaClientAuthenticationTlsBuilder(){
            this(true);
    }
    public KafkaClientAuthenticationTlsBuilder(Boolean validationEnabled){
            this(new KafkaClientAuthenticationTls(), validationEnabled);
    }
    public KafkaClientAuthenticationTlsBuilder(KafkaClientAuthenticationTlsFluent<?> fluent){
            this(fluent, true);
    }
    public KafkaClientAuthenticationTlsBuilder(KafkaClientAuthenticationTlsFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new KafkaClientAuthenticationTls(), validationEnabled);
    }
    public KafkaClientAuthenticationTlsBuilder(KafkaClientAuthenticationTlsFluent<?> fluent,KafkaClientAuthenticationTls instance){
            this(fluent, instance, true);
    }
    public KafkaClientAuthenticationTlsBuilder(KafkaClientAuthenticationTlsFluent<?> fluent,KafkaClientAuthenticationTls instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withCertificateAndKey(instance.getCertificateAndKey());

            this.validationEnabled = validationEnabled; 
    }
    public KafkaClientAuthenticationTlsBuilder(KafkaClientAuthenticationTls instance){
            this(instance,true);
    }
    public KafkaClientAuthenticationTlsBuilder(KafkaClientAuthenticationTls instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withCertificateAndKey(instance.getCertificateAndKey());

            this.validationEnabled = validationEnabled; 
    }

    public KafkaClientAuthenticationTls build(){
            KafkaClientAuthenticationTls buildable = new KafkaClientAuthenticationTls();
            buildable.setCertificateAndKey(fluent.getCertificateAndKey());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            KafkaClientAuthenticationTlsBuilder that = (KafkaClientAuthenticationTlsBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
