package io.strimzi.api.kafka.model.balancing;

import java.lang.Integer;
import java.lang.StringBuffer;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;
import java.util.Map;

public interface BrokerCapacityFluent<A extends BrokerCapacityFluent<A>> extends Fluent<A>{


    public String getDisk();
    public A withDisk(String disk);
    public Boolean hasDisk();
    public A withNewDisk(String arg1);
    public A withNewDisk(StringBuilder arg1);
    public A withNewDisk(StringBuffer arg1);
    public Integer getCpuUtilization();
    public A withCpuUtilization(Integer cpuUtilization);
    public Boolean hasCpuUtilization();
    public String getInboundNetwork();
    public A withInboundNetwork(String inboundNetwork);
    public Boolean hasInboundNetwork();
    public A withNewInboundNetwork(String arg1);
    public A withNewInboundNetwork(StringBuilder arg1);
    public A withNewInboundNetwork(StringBuffer arg1);
    public String getOutboundNetwork();
    public A withOutboundNetwork(String outboundNetwork);
    public Boolean hasOutboundNetwork();
    public A withNewOutboundNetwork(String arg1);
    public A withNewOutboundNetwork(StringBuilder arg1);
    public A withNewOutboundNetwork(StringBuffer arg1);



}
