package io.strimzi.api.kafka.model.balancing;

import java.lang.Integer;
import java.lang.StringBuffer;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class BrokerCapacityFluentImpl<A extends BrokerCapacityFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements BrokerCapacityFluent<A>{

    private String disk;
    private Integer cpuUtilization;
    private String inboundNetwork;
    private String outboundNetwork;

    public BrokerCapacityFluentImpl(){
    }
    public BrokerCapacityFluentImpl(BrokerCapacity instance){
            this.withDisk(instance.getDisk());

            this.withCpuUtilization(instance.getCpuUtilization());

            this.withInboundNetwork(instance.getInboundNetwork());

            this.withOutboundNetwork(instance.getOutboundNetwork());

    }

    public String getDisk(){
            return this.disk;
    }

    public A withDisk(String disk){
            this.disk=disk; return (A) this;
    }

    public Boolean hasDisk(){
            return this.disk != null;
    }

    public A withNewDisk(String arg1){
            return (A)withDisk(new String(arg1));
    }

    public A withNewDisk(StringBuilder arg1){
            return (A)withDisk(new String(arg1));
    }

    public A withNewDisk(StringBuffer arg1){
            return (A)withDisk(new String(arg1));
    }

    public Integer getCpuUtilization(){
            return this.cpuUtilization;
    }

    public A withCpuUtilization(Integer cpuUtilization){
            this.cpuUtilization=cpuUtilization; return (A) this;
    }

    public Boolean hasCpuUtilization(){
            return this.cpuUtilization != null;
    }

    public String getInboundNetwork(){
            return this.inboundNetwork;
    }

    public A withInboundNetwork(String inboundNetwork){
            this.inboundNetwork=inboundNetwork; return (A) this;
    }

    public Boolean hasInboundNetwork(){
            return this.inboundNetwork != null;
    }

    public A withNewInboundNetwork(String arg1){
            return (A)withInboundNetwork(new String(arg1));
    }

    public A withNewInboundNetwork(StringBuilder arg1){
            return (A)withInboundNetwork(new String(arg1));
    }

    public A withNewInboundNetwork(StringBuffer arg1){
            return (A)withInboundNetwork(new String(arg1));
    }

    public String getOutboundNetwork(){
            return this.outboundNetwork;
    }

    public A withOutboundNetwork(String outboundNetwork){
            this.outboundNetwork=outboundNetwork; return (A) this;
    }

    public Boolean hasOutboundNetwork(){
            return this.outboundNetwork != null;
    }

    public A withNewOutboundNetwork(String arg1){
            return (A)withOutboundNetwork(new String(arg1));
    }

    public A withNewOutboundNetwork(StringBuilder arg1){
            return (A)withOutboundNetwork(new String(arg1));
    }

    public A withNewOutboundNetwork(StringBuffer arg1){
            return (A)withOutboundNetwork(new String(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            BrokerCapacityFluentImpl that = (BrokerCapacityFluentImpl) o;
            if (disk != null ? !disk.equals(that.disk) :that.disk != null) return false;
            if (cpuUtilization != null ? !cpuUtilization.equals(that.cpuUtilization) :that.cpuUtilization != null) return false;
            if (inboundNetwork != null ? !inboundNetwork.equals(that.inboundNetwork) :that.inboundNetwork != null) return false;
            if (outboundNetwork != null ? !outboundNetwork.equals(that.outboundNetwork) :that.outboundNetwork != null) return false;
            return true;
    }




}
