package io.strimzi.api.kafka.model.connect;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ConnectorPluginBuilder extends ConnectorPluginFluentImpl<ConnectorPluginBuilder> implements VisitableBuilder<ConnectorPlugin,ConnectorPluginBuilder>{

    ConnectorPluginFluent<?> fluent;
    Boolean validationEnabled;

    public ConnectorPluginBuilder(){
            this(true);
    }
    public ConnectorPluginBuilder(Boolean validationEnabled){
            this(new ConnectorPlugin(), validationEnabled);
    }
    public ConnectorPluginBuilder(ConnectorPluginFluent<?> fluent){
            this(fluent, true);
    }
    public ConnectorPluginBuilder(ConnectorPluginFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ConnectorPlugin(), validationEnabled);
    }
    public ConnectorPluginBuilder(ConnectorPluginFluent<?> fluent,ConnectorPlugin instance){
            this(fluent, instance, true);
    }
    public ConnectorPluginBuilder(ConnectorPluginFluent<?> fluent,ConnectorPlugin instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withConnectorClass(instance.getConnectorClass());

            fluent.withType(instance.getType());

            fluent.withVersion(instance.getVersion());

            this.validationEnabled = validationEnabled; 
    }
    public ConnectorPluginBuilder(ConnectorPlugin instance){
            this(instance,true);
    }
    public ConnectorPluginBuilder(ConnectorPlugin instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withConnectorClass(instance.getConnectorClass());

            this.withType(instance.getType());

            this.withVersion(instance.getVersion());

            this.validationEnabled = validationEnabled; 
    }

    public ConnectorPlugin build(){
            ConnectorPlugin buildable = new ConnectorPlugin();
            buildable.setConnectorClass(fluent.getConnectorClass());
            buildable.setType(fluent.getType());
            buildable.setVersion(fluent.getVersion());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ConnectorPluginBuilder that = (ConnectorPluginBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
