package io.strimzi.api.kafka.model.connect;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ExternalConfigurationBuilder extends ExternalConfigurationFluentImpl<ExternalConfigurationBuilder> implements VisitableBuilder<ExternalConfiguration,ExternalConfigurationBuilder>{

    ExternalConfigurationFluent<?> fluent;
    Boolean validationEnabled;

    public ExternalConfigurationBuilder(){
            this(true);
    }
    public ExternalConfigurationBuilder(Boolean validationEnabled){
            this(new ExternalConfiguration(), validationEnabled);
    }
    public ExternalConfigurationBuilder(ExternalConfigurationFluent<?> fluent){
            this(fluent, true);
    }
    public ExternalConfigurationBuilder(ExternalConfigurationFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ExternalConfiguration(), validationEnabled);
    }
    public ExternalConfigurationBuilder(ExternalConfigurationFluent<?> fluent,ExternalConfiguration instance){
            this(fluent, instance, true);
    }
    public ExternalConfigurationBuilder(ExternalConfigurationFluent<?> fluent,ExternalConfiguration instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withEnv(instance.getEnv());

            fluent.withVolumes(instance.getVolumes());

            this.validationEnabled = validationEnabled; 
    }
    public ExternalConfigurationBuilder(ExternalConfiguration instance){
            this(instance,true);
    }
    public ExternalConfigurationBuilder(ExternalConfiguration instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withEnv(instance.getEnv());

            this.withVolumes(instance.getVolumes());

            this.validationEnabled = validationEnabled; 
    }

    public ExternalConfiguration build(){
            ExternalConfiguration buildable = new ExternalConfiguration();
            buildable.setEnv(fluent.getEnv());
            buildable.setVolumes(fluent.getVolumes());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ExternalConfigurationBuilder that = (ExternalConfigurationBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
