package io.strimzi.api.kafka.model.connect;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ExternalConfigurationEnvVarSourceBuilder extends ExternalConfigurationEnvVarSourceFluentImpl<ExternalConfigurationEnvVarSourceBuilder> implements VisitableBuilder<ExternalConfigurationEnvVarSource,ExternalConfigurationEnvVarSourceBuilder>{

    ExternalConfigurationEnvVarSourceFluent<?> fluent;
    Boolean validationEnabled;

    public ExternalConfigurationEnvVarSourceBuilder(){
            this(true);
    }
    public ExternalConfigurationEnvVarSourceBuilder(Boolean validationEnabled){
            this(new ExternalConfigurationEnvVarSource(), validationEnabled);
    }
    public ExternalConfigurationEnvVarSourceBuilder(ExternalConfigurationEnvVarSourceFluent<?> fluent){
            this(fluent, true);
    }
    public ExternalConfigurationEnvVarSourceBuilder(ExternalConfigurationEnvVarSourceFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ExternalConfigurationEnvVarSource(), validationEnabled);
    }
    public ExternalConfigurationEnvVarSourceBuilder(ExternalConfigurationEnvVarSourceFluent<?> fluent,ExternalConfigurationEnvVarSource instance){
            this(fluent, instance, true);
    }
    public ExternalConfigurationEnvVarSourceBuilder(ExternalConfigurationEnvVarSourceFluent<?> fluent,ExternalConfigurationEnvVarSource instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withSecretKeyRef(instance.getSecretKeyRef());

            fluent.withConfigMapKeyRef(instance.getConfigMapKeyRef());

            this.validationEnabled = validationEnabled; 
    }
    public ExternalConfigurationEnvVarSourceBuilder(ExternalConfigurationEnvVarSource instance){
            this(instance,true);
    }
    public ExternalConfigurationEnvVarSourceBuilder(ExternalConfigurationEnvVarSource instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withSecretKeyRef(instance.getSecretKeyRef());

            this.withConfigMapKeyRef(instance.getConfigMapKeyRef());

            this.validationEnabled = validationEnabled; 
    }

    public ExternalConfigurationEnvVarSource build(){
            ExternalConfigurationEnvVarSource buildable = new ExternalConfigurationEnvVarSource();
            buildable.setSecretKeyRef(fluent.getSecretKeyRef());
            buildable.setConfigMapKeyRef(fluent.getConfigMapKeyRef());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ExternalConfigurationEnvVarSourceBuilder that = (ExternalConfigurationEnvVarSourceBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
