package io.strimzi.api.kafka.model.connect;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.SecretKeySelector;
import io.fabric8.kubernetes.api.model.ConfigMapKeySelector;

public class ExternalConfigurationEnvVarSourceFluentImpl<A extends ExternalConfigurationEnvVarSourceFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements ExternalConfigurationEnvVarSourceFluent<A>{

    private SecretKeySelector secretKeyRef;
    private ConfigMapKeySelector configMapKeyRef;

    public ExternalConfigurationEnvVarSourceFluentImpl(){
    }
    public ExternalConfigurationEnvVarSourceFluentImpl(ExternalConfigurationEnvVarSource instance){
            this.withSecretKeyRef(instance.getSecretKeyRef());

            this.withConfigMapKeyRef(instance.getConfigMapKeyRef());

    }

    public SecretKeySelector getSecretKeyRef(){
            return this.secretKeyRef;
    }

    public A withSecretKeyRef(SecretKeySelector secretKeyRef){
            this.secretKeyRef=secretKeyRef; return (A) this;
    }

    public Boolean hasSecretKeyRef(){
            return this.secretKeyRef != null;
    }

    public A withNewSecretKeyRef(String key,String name,Boolean optional){
            return (A)withSecretKeyRef(new SecretKeySelector(key, name, optional));
    }

    public ConfigMapKeySelector getConfigMapKeyRef(){
            return this.configMapKeyRef;
    }

    public A withConfigMapKeyRef(ConfigMapKeySelector configMapKeyRef){
            this.configMapKeyRef=configMapKeyRef; return (A) this;
    }

    public Boolean hasConfigMapKeyRef(){
            return this.configMapKeyRef != null;
    }

    public A withNewConfigMapKeyRef(String key,String name,Boolean optional){
            return (A)withConfigMapKeyRef(new ConfigMapKeySelector(key, name, optional));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            ExternalConfigurationEnvVarSourceFluentImpl that = (ExternalConfigurationEnvVarSourceFluentImpl) o;
            if (secretKeyRef != null ? !secretKeyRef.equals(that.secretKeyRef) :that.secretKeyRef != null) return false;
            if (configMapKeyRef != null ? !configMapKeyRef.equals(that.configMapKeyRef) :that.configMapKeyRef != null) return false;
            return true;
    }




}
