package io.strimzi.api.kafka.model.connect.build;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class BuildBuilder extends BuildFluentImpl<BuildBuilder> implements VisitableBuilder<Build,BuildBuilder>{

    BuildFluent<?> fluent;
    Boolean validationEnabled;

    public BuildBuilder(){
            this(true);
    }
    public BuildBuilder(Boolean validationEnabled){
            this(new Build(), validationEnabled);
    }
    public BuildBuilder(BuildFluent<?> fluent){
            this(fluent, true);
    }
    public BuildBuilder(BuildFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new Build(), validationEnabled);
    }
    public BuildBuilder(BuildFluent<?> fluent,Build instance){
            this(fluent, instance, true);
    }
    public BuildBuilder(BuildFluent<?> fluent,Build instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withOutput(instance.getOutput());

            fluent.withPlugins(instance.getPlugins());

            fluent.withResources(instance.getResources());

            this.validationEnabled = validationEnabled; 
    }
    public BuildBuilder(Build instance){
            this(instance,true);
    }
    public BuildBuilder(Build instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withOutput(instance.getOutput());

            this.withPlugins(instance.getPlugins());

            this.withResources(instance.getResources());

            this.validationEnabled = validationEnabled; 
    }

    public Build build(){
            Build buildable = new Build();
            buildable.setOutput(fluent.getOutput());
            buildable.setPlugins(fluent.getPlugins());
            buildable.setResources(fluent.getResources());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            BuildBuilder that = (BuildBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
