package io.strimzi.api.kafka.model.connect.build;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class DockerOutputBuilder extends DockerOutputFluentImpl<DockerOutputBuilder> implements VisitableBuilder<DockerOutput,DockerOutputBuilder>{

    DockerOutputFluent<?> fluent;
    Boolean validationEnabled;

    public DockerOutputBuilder(){
            this(true);
    }
    public DockerOutputBuilder(Boolean validationEnabled){
            this(new DockerOutput(), validationEnabled);
    }
    public DockerOutputBuilder(DockerOutputFluent<?> fluent){
            this(fluent, true);
    }
    public DockerOutputBuilder(DockerOutputFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new DockerOutput(), validationEnabled);
    }
    public DockerOutputBuilder(DockerOutputFluent<?> fluent,DockerOutput instance){
            this(fluent, instance, true);
    }
    public DockerOutputBuilder(DockerOutputFluent<?> fluent,DockerOutput instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withImage(instance.getImage());

            fluent.withPushSecret(instance.getPushSecret());

            this.validationEnabled = validationEnabled; 
    }
    public DockerOutputBuilder(DockerOutput instance){
            this(instance,true);
    }
    public DockerOutputBuilder(DockerOutput instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withImage(instance.getImage());

            this.withPushSecret(instance.getPushSecret());

            this.validationEnabled = validationEnabled; 
    }

    public DockerOutput build(){
            DockerOutput buildable = new DockerOutput();
            buildable.setImage(fluent.getImage());
            buildable.setPushSecret(fluent.getPushSecret());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            DockerOutputBuilder that = (DockerOutputBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
