package io.strimzi.api.kafka.model.connect.build;

import java.lang.StringBuffer;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class DockerOutputFluentImpl<A extends DockerOutputFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements DockerOutputFluent<A>{

    private String image;
    private String pushSecret;

    public DockerOutputFluentImpl(){
    }
    public DockerOutputFluentImpl(DockerOutput instance){
            this.withImage(instance.getImage());

            this.withPushSecret(instance.getPushSecret());

    }

    public String getImage(){
            return this.image;
    }

    public A withImage(String image){
            this.image=image; return (A) this;
    }

    public Boolean hasImage(){
            return this.image != null;
    }

    public A withNewImage(String arg1){
            return (A)withImage(new String(arg1));
    }

    public A withNewImage(StringBuilder arg1){
            return (A)withImage(new String(arg1));
    }

    public A withNewImage(StringBuffer arg1){
            return (A)withImage(new String(arg1));
    }

    public String getPushSecret(){
            return this.pushSecret;
    }

    public A withPushSecret(String pushSecret){
            this.pushSecret=pushSecret; return (A) this;
    }

    public Boolean hasPushSecret(){
            return this.pushSecret != null;
    }

    public A withNewPushSecret(String arg1){
            return (A)withPushSecret(new String(arg1));
    }

    public A withNewPushSecret(StringBuilder arg1){
            return (A)withPushSecret(new String(arg1));
    }

    public A withNewPushSecret(StringBuffer arg1){
            return (A)withPushSecret(new String(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            DockerOutputFluentImpl that = (DockerOutputFluentImpl) o;
            if (image != null ? !image.equals(that.image) :that.image != null) return false;
            if (pushSecret != null ? !pushSecret.equals(that.pushSecret) :that.pushSecret != null) return false;
            return true;
    }




}
