package io.strimzi.api.kafka.model.connect.build;

import java.lang.StringBuffer;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class DownloadableArtifactFluentImpl<A extends DownloadableArtifactFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements DownloadableArtifactFluent<A>{

    private String url;
    private String sha512sum;

    public DownloadableArtifactFluentImpl(){
    }
    public DownloadableArtifactFluentImpl(DownloadableArtifact instance){
            this.withUrl(instance.getUrl());

            this.withSha512sum(instance.getSha512sum());

    }

    public String getUrl(){
            return this.url;
    }

    public A withUrl(String url){
            this.url=url; return (A) this;
    }

    public Boolean hasUrl(){
            return this.url != null;
    }

    public A withNewUrl(String arg1){
            return (A)withUrl(new String(arg1));
    }

    public A withNewUrl(StringBuilder arg1){
            return (A)withUrl(new String(arg1));
    }

    public A withNewUrl(StringBuffer arg1){
            return (A)withUrl(new String(arg1));
    }

    public String getSha512sum(){
            return this.sha512sum;
    }

    public A withSha512sum(String sha512sum){
            this.sha512sum=sha512sum; return (A) this;
    }

    public Boolean hasSha512sum(){
            return this.sha512sum != null;
    }

    public A withNewSha512sum(String arg1){
            return (A)withSha512sum(new String(arg1));
    }

    public A withNewSha512sum(StringBuilder arg1){
            return (A)withSha512sum(new String(arg1));
    }

    public A withNewSha512sum(StringBuffer arg1){
            return (A)withSha512sum(new String(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            DownloadableArtifactFluentImpl that = (DownloadableArtifactFluentImpl) o;
            if (url != null ? !url.equals(that.url) :that.url != null) return false;
            if (sha512sum != null ? !sha512sum.equals(that.sha512sum) :that.sha512sum != null) return false;
            return true;
    }




}
