package io.strimzi.api.kafka.model.connect.build;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ImageStreamOutputBuilder extends ImageStreamOutputFluentImpl<ImageStreamOutputBuilder> implements VisitableBuilder<ImageStreamOutput,ImageStreamOutputBuilder>{

    ImageStreamOutputFluent<?> fluent;
    Boolean validationEnabled;

    public ImageStreamOutputBuilder(){
            this(true);
    }
    public ImageStreamOutputBuilder(Boolean validationEnabled){
            this(new ImageStreamOutput(), validationEnabled);
    }
    public ImageStreamOutputBuilder(ImageStreamOutputFluent<?> fluent){
            this(fluent, true);
    }
    public ImageStreamOutputBuilder(ImageStreamOutputFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ImageStreamOutput(), validationEnabled);
    }
    public ImageStreamOutputBuilder(ImageStreamOutputFluent<?> fluent,ImageStreamOutput instance){
            this(fluent, instance, true);
    }
    public ImageStreamOutputBuilder(ImageStreamOutputFluent<?> fluent,ImageStreamOutput instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withImage(instance.getImage());

            this.validationEnabled = validationEnabled; 
    }
    public ImageStreamOutputBuilder(ImageStreamOutput instance){
            this(instance,true);
    }
    public ImageStreamOutputBuilder(ImageStreamOutput instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withImage(instance.getImage());

            this.validationEnabled = validationEnabled; 
    }

    public ImageStreamOutput build(){
            ImageStreamOutput buildable = new ImageStreamOutput();
            buildable.setImage(fluent.getImage());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ImageStreamOutputBuilder that = (ImageStreamOutputBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
