package io.strimzi.api.kafka.model.connect.build;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class JarArtifactBuilder extends JarArtifactFluentImpl<JarArtifactBuilder> implements VisitableBuilder<JarArtifact,JarArtifactBuilder>{

    JarArtifactFluent<?> fluent;
    Boolean validationEnabled;

    public JarArtifactBuilder(){
            this(true);
    }
    public JarArtifactBuilder(Boolean validationEnabled){
            this(new JarArtifact(), validationEnabled);
    }
    public JarArtifactBuilder(JarArtifactFluent<?> fluent){
            this(fluent, true);
    }
    public JarArtifactBuilder(JarArtifactFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new JarArtifact(), validationEnabled);
    }
    public JarArtifactBuilder(JarArtifactFluent<?> fluent,JarArtifact instance){
            this(fluent, instance, true);
    }
    public JarArtifactBuilder(JarArtifactFluent<?> fluent,JarArtifact instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withUrl(instance.getUrl());

            fluent.withSha512sum(instance.getSha512sum());

            this.validationEnabled = validationEnabled; 
    }
    public JarArtifactBuilder(JarArtifact instance){
            this(instance,true);
    }
    public JarArtifactBuilder(JarArtifact instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withUrl(instance.getUrl());

            this.withSha512sum(instance.getSha512sum());

            this.validationEnabled = validationEnabled; 
    }

    public JarArtifact build(){
            JarArtifact buildable = new JarArtifact();
            buildable.setUrl(fluent.getUrl());
            buildable.setSha512sum(fluent.getSha512sum());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            JarArtifactBuilder that = (JarArtifactBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
