package io.strimzi.api.kafka.model.connect.build;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class PluginBuilder extends PluginFluentImpl<PluginBuilder> implements VisitableBuilder<Plugin,PluginBuilder>{

    PluginFluent<?> fluent;
    Boolean validationEnabled;

    public PluginBuilder(){
            this(true);
    }
    public PluginBuilder(Boolean validationEnabled){
            this(new Plugin(), validationEnabled);
    }
    public PluginBuilder(PluginFluent<?> fluent){
            this(fluent, true);
    }
    public PluginBuilder(PluginFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new Plugin(), validationEnabled);
    }
    public PluginBuilder(PluginFluent<?> fluent,Plugin instance){
            this(fluent, instance, true);
    }
    public PluginBuilder(PluginFluent<?> fluent,Plugin instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withName(instance.getName());

            fluent.withArtifacts(instance.getArtifacts());

            this.validationEnabled = validationEnabled; 
    }
    public PluginBuilder(Plugin instance){
            this(instance,true);
    }
    public PluginBuilder(Plugin instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withName(instance.getName());

            this.withArtifacts(instance.getArtifacts());

            this.validationEnabled = validationEnabled; 
    }

    public Plugin build(){
            Plugin buildable = new Plugin();
            buildable.setName(fluent.getName());
            buildable.setArtifacts(fluent.getArtifacts());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            PluginBuilder that = (PluginBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
