package io.strimzi.api.kafka.model.connect.build;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.StringBuffer;
import java.util.Collection;
import java.lang.Object;

public class PluginFluentImpl<A extends PluginFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements PluginFluent<A>{

    private String name;
    private java.util.List<VisitableBuilder<? extends Artifact,?>> artifacts;

    public PluginFluentImpl(){
    }
    public PluginFluentImpl(Plugin instance){
            this.withName(instance.getName());

            this.withArtifacts(instance.getArtifacts());

    }

    public String getName(){
            return this.name;
    }

    public A withName(String name){
            this.name=name; return (A) this;
    }

    public Boolean hasName(){
            return this.name != null;
    }

    public A withNewName(String arg1){
            return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuilder arg1){
            return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuffer arg1){
            return (A)withName(new String(arg1));
    }

    public A addToArtifacts(VisitableBuilder<? extends Artifact,?> builder){
            if (this.artifacts == null) {this.artifacts = new ArrayList<VisitableBuilder<? extends Artifact,?>>();}
            _visitables.get("artifacts").add(builder);this.artifacts.add(builder); return (A)this;
    }

    public A addToArtifacts(int index,VisitableBuilder<? extends Artifact,?> builder){
            if (this.artifacts == null) {this.artifacts = new ArrayList<VisitableBuilder<? extends Artifact,?>>();}
            _visitables.get("artifacts").add(index, builder);this.artifacts.add(index, builder); return (A)this;
    }

    public A addToArtifacts(int index,Artifact item){
            if (item instanceof JarArtifact){addToJarArtifactArtifacts(index, (JarArtifact)item);}
 else if (item instanceof TgzArtifact){addToTgzArtifactArtifacts(index, (TgzArtifact)item);}

            return (A)this;
    }

    public A setToArtifacts(int index,Artifact item){
            if (item instanceof JarArtifact){setToJarArtifactArtifacts(index, (JarArtifact)item);}
 else if (item instanceof TgzArtifact){setToTgzArtifactArtifacts(index, (TgzArtifact)item);}

            return (A)this;
    }

    public A addToArtifacts(Artifact... items){
             if (items != null && items.length > 0 && this.artifacts== null) {this.artifacts = new ArrayList<VisitableBuilder<? extends Artifact,?>>();}
            for (Artifact item : items) { 
            if (item instanceof JarArtifact){addToJarArtifactArtifacts((JarArtifact)item);}
 else if (item instanceof TgzArtifact){addToTgzArtifactArtifacts((TgzArtifact)item);}

            else {  VisitableBuilder<? extends Artifact,?> builder = builderOf(item); _visitables.get("artifacts").add(builder);this.artifacts.add(builder); }
            } return (A)this;
    }

    public A addAllToArtifacts(Collection<Artifact> items){
             if (items != null && items.size() > 0 && this.artifacts== null) {this.artifacts = new ArrayList<VisitableBuilder<? extends Artifact,?>>();}
            for (Artifact item : items) { 
            if (item instanceof JarArtifact){addToJarArtifactArtifacts((JarArtifact)item);}
 else if (item instanceof TgzArtifact){addToTgzArtifactArtifacts((TgzArtifact)item);}

            else {  VisitableBuilder<? extends Artifact,?> builder = builderOf(item); _visitables.get("artifacts").add(builder);this.artifacts.add(builder); }
            } return (A)this;
    }

    public A removeFromArtifacts(VisitableBuilder<? extends Artifact,?> builder){
            if (this.artifacts == null) {this.artifacts = new ArrayList<VisitableBuilder<? extends Artifact,?>>();}
            _visitables.get("artifacts").remove(builder);this.artifacts.remove(builder); return (A)this;
    }

    public A removeFromArtifacts(Artifact... items){
            for (Artifact item : items) {if (item instanceof JarArtifact){removeFromJarArtifactArtifacts((JarArtifact)item);}
 else if (item instanceof TgzArtifact){removeFromTgzArtifactArtifacts((TgzArtifact)item);}

            else {  VisitableBuilder<? extends Artifact,?> builder = builderOf(item); _visitables.get("artifacts").remove(builder);this.artifacts.remove(builder); }
            } return (A)this;
    }

    public A removeAllFromArtifacts(Collection<Artifact> items){
            for (Artifact item : items) {if (item instanceof JarArtifact){removeFromJarArtifactArtifacts((JarArtifact)item);}
 else if (item instanceof TgzArtifact){removeFromTgzArtifactArtifacts((TgzArtifact)item);}

            else {  VisitableBuilder<? extends Artifact,?> builder = builderOf(item); _visitables.get("artifacts").remove(builder);this.artifacts.remove(builder); }
            } return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildArtifacts instead.
 * @return The buildable object.
 */
@Deprecated public java.util.List<Artifact> getArtifacts(){
            return build(artifacts);
    }

    public java.util.List<Artifact> buildArtifacts(){
            return build(artifacts);
    }

    public Artifact buildArtifact(int index){
            return this.artifacts.get(index).build();
    }

    public Artifact buildFirstArtifact(){
            return this.artifacts.get(0).build();
    }

    public Artifact buildLastArtifact(){
            return this.artifacts.get(artifacts.size() - 1).build();
    }

    public Artifact buildMatchingArtifact(io.fabric8.kubernetes.api.builder.Predicate<VisitableBuilder<? extends Artifact,?>> predicate){
            for (VisitableBuilder<? extends Artifact,?> item: artifacts) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingArtifact(io.fabric8.kubernetes.api.builder.Predicate<VisitableBuilder<? extends Artifact,?>> predicate){
            for (VisitableBuilder<? extends Artifact,?> item: artifacts) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withArtifacts(java.util.List<Artifact> artifacts){
            if (this.artifacts != null) { _visitables.get("artifacts").removeAll(this.artifacts);}
            if (artifacts != null) {this.artifacts = new ArrayList<VisitableBuilder<? extends Artifact,?>>(); for (Artifact item : artifacts){this.addToArtifacts(item);}} else { this.artifacts = null;} return (A) this;
    }

    public A withArtifacts(Artifact... artifacts){
            if (this.artifacts != null) {this.artifacts.clear();}
            if (artifacts != null) {for (Artifact item :artifacts){ this.addToArtifacts(item);}} return (A) this;
    }

    public Boolean hasArtifacts(){
            return artifacts != null && !artifacts.isEmpty();
    }

    public A addToJarArtifactArtifacts(int index,JarArtifact item){
            if (this.artifacts == null) {this.artifacts = new ArrayList<VisitableBuilder<? extends Artifact,?>>();}
            JarArtifactBuilder builder = new JarArtifactBuilder(item);_visitables.get("artifacts").add(index >= 0 ? index : _visitables.get("artifacts").size(), builder);this.artifacts.add(index >= 0 ? index : artifacts.size(), builder); return (A)this;
    }

    public A setToJarArtifactArtifacts(int index,JarArtifact item){
            if (this.artifacts == null) {this.artifacts = new ArrayList<VisitableBuilder<? extends Artifact,?>>();}
            JarArtifactBuilder builder = new JarArtifactBuilder(item);
            if (index < 0 || index >= _visitables.get("artifacts").size()) { _visitables.get("artifacts").add(builder); } else { _visitables.get("artifacts").set(index, builder);}
            if (index < 0 || index >= artifacts.size()) { artifacts.add(builder); } else { artifacts.set(index, builder);}
             return (A)this;
    }

    public A addToJarArtifactArtifacts(JarArtifact... items){
            if (this.artifacts == null) {this.artifacts = new ArrayList<VisitableBuilder<? extends Artifact,?>>();}
            for (JarArtifact item : items) {JarArtifactBuilder builder = new JarArtifactBuilder(item);_visitables.get("artifacts").add(builder);this.artifacts.add(builder);} return (A)this;
    }

    public A addAllToJarArtifactArtifacts(Collection<JarArtifact> items){
            if (this.artifacts == null) {this.artifacts = new ArrayList<VisitableBuilder<? extends Artifact,?>>();}
            for (JarArtifact item : items) {JarArtifactBuilder builder = new JarArtifactBuilder(item);_visitables.get("artifacts").add(builder);this.artifacts.add(builder);} return (A)this;
    }

    public A removeFromJarArtifactArtifacts(JarArtifact... items){
            for (JarArtifact item : items) {JarArtifactBuilder builder = new JarArtifactBuilder(item);_visitables.get("artifacts").remove(builder);if (this.artifacts != null) {this.artifacts.remove(builder);}} return (A)this;
    }

    public A removeAllFromJarArtifactArtifacts(Collection<JarArtifact> items){
            for (JarArtifact item : items) {JarArtifactBuilder builder = new JarArtifactBuilder(item);_visitables.get("artifacts").remove(builder);if (this.artifacts != null) {this.artifacts.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromJarArtifactArtifacts(io.fabric8.kubernetes.api.builder.Predicate<VisitableBuilder<? extends Artifact,?>> predicate){
            if (artifacts == null) return (A) this;
            final Iterator<VisitableBuilder<? extends Artifact,?>> each = artifacts.iterator();
            final List visitables = _visitables.get("artifacts");
            while (each.hasNext()) {
              VisitableBuilder<? extends Artifact,?> builder = each.next();
              if (predicate.apply(builder)) {
                visitables.remove(builder);
                each.remove();
              }
            }
            return (A)this;
    }

    public PluginFluent.JarArtifactArtifactsNested<A> addNewJarArtifactArtifact(){
            return new JarArtifactArtifactsNestedImpl();
    }

    public PluginFluent.JarArtifactArtifactsNested<A> addNewJarArtifactArtifactLike(JarArtifact item){
            return new JarArtifactArtifactsNestedImpl(-1, item);
    }

    public PluginFluent.JarArtifactArtifactsNested<A> setNewJarArtifactArtifactLike(int index,JarArtifact item){
            return new JarArtifactArtifactsNestedImpl(index, item);
    }

    public A addToTgzArtifactArtifacts(int index,TgzArtifact item){
            if (this.artifacts == null) {this.artifacts = new ArrayList<VisitableBuilder<? extends Artifact,?>>();}
            TgzArtifactBuilder builder = new TgzArtifactBuilder(item);_visitables.get("artifacts").add(index >= 0 ? index : _visitables.get("artifacts").size(), builder);this.artifacts.add(index >= 0 ? index : artifacts.size(), builder); return (A)this;
    }

    public A setToTgzArtifactArtifacts(int index,TgzArtifact item){
            if (this.artifacts == null) {this.artifacts = new ArrayList<VisitableBuilder<? extends Artifact,?>>();}
            TgzArtifactBuilder builder = new TgzArtifactBuilder(item);
            if (index < 0 || index >= _visitables.get("artifacts").size()) { _visitables.get("artifacts").add(builder); } else { _visitables.get("artifacts").set(index, builder);}
            if (index < 0 || index >= artifacts.size()) { artifacts.add(builder); } else { artifacts.set(index, builder);}
             return (A)this;
    }

    public A addToTgzArtifactArtifacts(TgzArtifact... items){
            if (this.artifacts == null) {this.artifacts = new ArrayList<VisitableBuilder<? extends Artifact,?>>();}
            for (TgzArtifact item : items) {TgzArtifactBuilder builder = new TgzArtifactBuilder(item);_visitables.get("artifacts").add(builder);this.artifacts.add(builder);} return (A)this;
    }

    public A addAllToTgzArtifactArtifacts(Collection<TgzArtifact> items){
            if (this.artifacts == null) {this.artifacts = new ArrayList<VisitableBuilder<? extends Artifact,?>>();}
            for (TgzArtifact item : items) {TgzArtifactBuilder builder = new TgzArtifactBuilder(item);_visitables.get("artifacts").add(builder);this.artifacts.add(builder);} return (A)this;
    }

    public A removeFromTgzArtifactArtifacts(TgzArtifact... items){
            for (TgzArtifact item : items) {TgzArtifactBuilder builder = new TgzArtifactBuilder(item);_visitables.get("artifacts").remove(builder);if (this.artifacts != null) {this.artifacts.remove(builder);}} return (A)this;
    }

    public A removeAllFromTgzArtifactArtifacts(Collection<TgzArtifact> items){
            for (TgzArtifact item : items) {TgzArtifactBuilder builder = new TgzArtifactBuilder(item);_visitables.get("artifacts").remove(builder);if (this.artifacts != null) {this.artifacts.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromTgzArtifactArtifacts(io.fabric8.kubernetes.api.builder.Predicate<VisitableBuilder<? extends Artifact,?>> predicate){
            if (artifacts == null) return (A) this;
            final Iterator<VisitableBuilder<? extends Artifact,?>> each = artifacts.iterator();
            final List visitables = _visitables.get("artifacts");
            while (each.hasNext()) {
              VisitableBuilder<? extends Artifact,?> builder = each.next();
              if (predicate.apply(builder)) {
                visitables.remove(builder);
                each.remove();
              }
            }
            return (A)this;
    }

    public PluginFluent.TgzArtifactArtifactsNested<A> addNewTgzArtifactArtifact(){
            return new TgzArtifactArtifactsNestedImpl();
    }

    public PluginFluent.TgzArtifactArtifactsNested<A> addNewTgzArtifactArtifactLike(TgzArtifact item){
            return new TgzArtifactArtifactsNestedImpl(-1, item);
    }

    public PluginFluent.TgzArtifactArtifactsNested<A> setNewTgzArtifactArtifactLike(int index,TgzArtifact item){
            return new TgzArtifactArtifactsNestedImpl(index, item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            PluginFluentImpl that = (PluginFluentImpl) o;
            if (name != null ? !name.equals(that.name) :that.name != null) return false;
            if (artifacts != null ? !artifacts.equals(that.artifacts) :that.artifacts != null) return false;
            return true;
    }


    public class JarArtifactArtifactsNestedImpl<N> extends JarArtifactFluentImpl<PluginFluent.JarArtifactArtifactsNested<N>> implements PluginFluent.JarArtifactArtifactsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final JarArtifactBuilder builder;
        private final int index;
    
            JarArtifactArtifactsNestedImpl(int index,JarArtifact item){
                    this.index = index;
                    this.builder = new JarArtifactBuilder(this, item);
            }
            JarArtifactArtifactsNestedImpl(){
                    this.index = -1;
                    this.builder = new JarArtifactBuilder(this);
            }
    
    public N and(){
            return (N) PluginFluentImpl.this.setToJarArtifactArtifacts(index, builder.build());
    }
    public N endJarArtifactArtifact(){
            return and();
    }

}
    public class TgzArtifactArtifactsNestedImpl<N> extends TgzArtifactFluentImpl<PluginFluent.TgzArtifactArtifactsNested<N>> implements PluginFluent.TgzArtifactArtifactsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final TgzArtifactBuilder builder;
        private final int index;
    
            TgzArtifactArtifactsNestedImpl(int index,TgzArtifact item){
                    this.index = index;
                    this.builder = new TgzArtifactBuilder(this, item);
            }
            TgzArtifactArtifactsNestedImpl(){
                    this.index = -1;
                    this.builder = new TgzArtifactBuilder(this);
            }
    
    public N and(){
            return (N) PluginFluentImpl.this.setToTgzArtifactArtifacts(index, builder.build());
    }
    public N endTgzArtifactArtifact(){
            return and();
    }

}


}
