package io.strimzi.api.kafka.model.connect.build;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class TgzArtifactBuilder extends TgzArtifactFluentImpl<TgzArtifactBuilder> implements VisitableBuilder<TgzArtifact,TgzArtifactBuilder>{

    TgzArtifactFluent<?> fluent;
    Boolean validationEnabled;

    public TgzArtifactBuilder(){
            this(true);
    }
    public TgzArtifactBuilder(Boolean validationEnabled){
            this(new TgzArtifact(), validationEnabled);
    }
    public TgzArtifactBuilder(TgzArtifactFluent<?> fluent){
            this(fluent, true);
    }
    public TgzArtifactBuilder(TgzArtifactFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new TgzArtifact(), validationEnabled);
    }
    public TgzArtifactBuilder(TgzArtifactFluent<?> fluent,TgzArtifact instance){
            this(fluent, instance, true);
    }
    public TgzArtifactBuilder(TgzArtifactFluent<?> fluent,TgzArtifact instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withUrl(instance.getUrl());

            fluent.withSha512sum(instance.getSha512sum());

            this.validationEnabled = validationEnabled; 
    }
    public TgzArtifactBuilder(TgzArtifact instance){
            this(instance,true);
    }
    public TgzArtifactBuilder(TgzArtifact instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withUrl(instance.getUrl());

            this.withSha512sum(instance.getSha512sum());

            this.validationEnabled = validationEnabled; 
    }

    public TgzArtifact build(){
            TgzArtifact buildable = new TgzArtifact();
            buildable.setUrl(fluent.getUrl());
            buildable.setSha512sum(fluent.getSha512sum());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            TgzArtifactBuilder that = (TgzArtifactBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
