package io.strimzi.api.kafka.model.listener;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ExternalListenerBootstrapOverrideBuilder extends ExternalListenerBootstrapOverrideFluentImpl<ExternalListenerBootstrapOverrideBuilder> implements VisitableBuilder<ExternalListenerBootstrapOverride,ExternalListenerBootstrapOverrideBuilder>{

    ExternalListenerBootstrapOverrideFluent<?> fluent;
    Boolean validationEnabled;

    public ExternalListenerBootstrapOverrideBuilder(){
            this(true);
    }
    public ExternalListenerBootstrapOverrideBuilder(Boolean validationEnabled){
            this(new ExternalListenerBootstrapOverride(), validationEnabled);
    }
    public ExternalListenerBootstrapOverrideBuilder(ExternalListenerBootstrapOverrideFluent<?> fluent){
            this(fluent, true);
    }
    public ExternalListenerBootstrapOverrideBuilder(ExternalListenerBootstrapOverrideFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ExternalListenerBootstrapOverride(), validationEnabled);
    }
    public ExternalListenerBootstrapOverrideBuilder(ExternalListenerBootstrapOverrideFluent<?> fluent,ExternalListenerBootstrapOverride instance){
            this(fluent, instance, true);
    }
    public ExternalListenerBootstrapOverrideBuilder(ExternalListenerBootstrapOverrideFluent<?> fluent,ExternalListenerBootstrapOverride instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withAddress(instance.getAddress());

            this.validationEnabled = validationEnabled; 
    }
    public ExternalListenerBootstrapOverrideBuilder(ExternalListenerBootstrapOverride instance){
            this(instance,true);
    }
    public ExternalListenerBootstrapOverrideBuilder(ExternalListenerBootstrapOverride instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withAddress(instance.getAddress());

            this.validationEnabled = validationEnabled; 
    }

    public ExternalListenerBootstrapOverride build(){
            ExternalListenerBootstrapOverride buildable = new ExternalListenerBootstrapOverride();
            buildable.setAddress(fluent.getAddress());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ExternalListenerBootstrapOverrideBuilder that = (ExternalListenerBootstrapOverrideBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
