package io.strimzi.api.kafka.model.listener;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ExternalListenerBrokerOverrideBuilder extends ExternalListenerBrokerOverrideFluentImpl<ExternalListenerBrokerOverrideBuilder> implements VisitableBuilder<ExternalListenerBrokerOverride,ExternalListenerBrokerOverrideBuilder>{

    ExternalListenerBrokerOverrideFluent<?> fluent;
    Boolean validationEnabled;

    public ExternalListenerBrokerOverrideBuilder(){
            this(true);
    }
    public ExternalListenerBrokerOverrideBuilder(Boolean validationEnabled){
            this(new ExternalListenerBrokerOverride(), validationEnabled);
    }
    public ExternalListenerBrokerOverrideBuilder(ExternalListenerBrokerOverrideFluent<?> fluent){
            this(fluent, true);
    }
    public ExternalListenerBrokerOverrideBuilder(ExternalListenerBrokerOverrideFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ExternalListenerBrokerOverride(), validationEnabled);
    }
    public ExternalListenerBrokerOverrideBuilder(ExternalListenerBrokerOverrideFluent<?> fluent,ExternalListenerBrokerOverride instance){
            this(fluent, instance, true);
    }
    public ExternalListenerBrokerOverrideBuilder(ExternalListenerBrokerOverrideFluent<?> fluent,ExternalListenerBrokerOverride instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withBroker(instance.getBroker());

            fluent.withAdvertisedHost(instance.getAdvertisedHost());

            fluent.withAdvertisedPort(instance.getAdvertisedPort());

            this.validationEnabled = validationEnabled; 
    }
    public ExternalListenerBrokerOverrideBuilder(ExternalListenerBrokerOverride instance){
            this(instance,true);
    }
    public ExternalListenerBrokerOverrideBuilder(ExternalListenerBrokerOverride instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withBroker(instance.getBroker());

            this.withAdvertisedHost(instance.getAdvertisedHost());

            this.withAdvertisedPort(instance.getAdvertisedPort());

            this.validationEnabled = validationEnabled; 
    }

    public ExternalListenerBrokerOverride build(){
            ExternalListenerBrokerOverride buildable = new ExternalListenerBrokerOverride();
            buildable.setBroker(fluent.getBroker());
            buildable.setAdvertisedHost(fluent.getAdvertisedHost());
            buildable.setAdvertisedPort(fluent.getAdvertisedPort());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ExternalListenerBrokerOverrideBuilder that = (ExternalListenerBrokerOverrideBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
