package io.strimzi.api.kafka.model.listener;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class IngressListenerConfigurationFluentImpl<A extends IngressListenerConfigurationFluent<A>> extends KafkaListenerExternalConfigurationFluentImpl<A> implements IngressListenerConfigurationFluent<A>{

    private IngressListenerBootstrapConfigurationBuilder bootstrap;
    private java.util.List<IngressListenerBrokerConfigurationBuilder> brokers;

    public IngressListenerConfigurationFluentImpl(){
    }
    public IngressListenerConfigurationFluentImpl(IngressListenerConfiguration instance){
            this.withBootstrap(instance.getBootstrap());

            this.withBrokers(instance.getBrokers());

            this.withBrokerCertChainAndKey(instance.getBrokerCertChainAndKey());

    }

    
/**
 * This method has been deprecated, please use method buildBootstrap instead.
 * @return The buildable object.
 */
@Deprecated public IngressListenerBootstrapConfiguration getBootstrap(){
            return this.bootstrap!=null?this.bootstrap.build():null;
    }

    public IngressListenerBootstrapConfiguration buildBootstrap(){
            return this.bootstrap!=null?this.bootstrap.build():null;
    }

    public A withBootstrap(IngressListenerBootstrapConfiguration bootstrap){
            _visitables.get("bootstrap").remove(this.bootstrap);
            if (bootstrap!=null){ this.bootstrap= new IngressListenerBootstrapConfigurationBuilder(bootstrap); _visitables.get("bootstrap").add(this.bootstrap);} return (A) this;
    }

    public Boolean hasBootstrap(){
            return this.bootstrap != null;
    }

    public IngressListenerConfigurationFluent.BootstrapNested<A> withNewBootstrap(){
            return new BootstrapNestedImpl();
    }

    public IngressListenerConfigurationFluent.BootstrapNested<A> withNewBootstrapLike(IngressListenerBootstrapConfiguration item){
            return new BootstrapNestedImpl(item);
    }

    public IngressListenerConfigurationFluent.BootstrapNested<A> editBootstrap(){
            return withNewBootstrapLike(getBootstrap());
    }

    public IngressListenerConfigurationFluent.BootstrapNested<A> editOrNewBootstrap(){
            return withNewBootstrapLike(getBootstrap() != null ? getBootstrap(): new IngressListenerBootstrapConfigurationBuilder().build());
    }

    public IngressListenerConfigurationFluent.BootstrapNested<A> editOrNewBootstrapLike(IngressListenerBootstrapConfiguration item){
            return withNewBootstrapLike(getBootstrap() != null ? getBootstrap(): item);
    }

    public A addToBrokers(int index,IngressListenerBrokerConfiguration item){
            if (this.brokers == null) {this.brokers = new ArrayList<IngressListenerBrokerConfigurationBuilder>();}
            IngressListenerBrokerConfigurationBuilder builder = new IngressListenerBrokerConfigurationBuilder(item);_visitables.get("brokers").add(index >= 0 ? index : _visitables.get("brokers").size(), builder);this.brokers.add(index >= 0 ? index : brokers.size(), builder); return (A)this;
    }

    public A setToBrokers(int index,IngressListenerBrokerConfiguration item){
            if (this.brokers == null) {this.brokers = new ArrayList<IngressListenerBrokerConfigurationBuilder>();}
            IngressListenerBrokerConfigurationBuilder builder = new IngressListenerBrokerConfigurationBuilder(item);
            if (index < 0 || index >= _visitables.get("brokers").size()) { _visitables.get("brokers").add(builder); } else { _visitables.get("brokers").set(index, builder);}
            if (index < 0 || index >= brokers.size()) { brokers.add(builder); } else { brokers.set(index, builder);}
             return (A)this;
    }

    public A addToBrokers(IngressListenerBrokerConfiguration... items){
            if (this.brokers == null) {this.brokers = new ArrayList<IngressListenerBrokerConfigurationBuilder>();}
            for (IngressListenerBrokerConfiguration item : items) {IngressListenerBrokerConfigurationBuilder builder = new IngressListenerBrokerConfigurationBuilder(item);_visitables.get("brokers").add(builder);this.brokers.add(builder);} return (A)this;
    }

    public A addAllToBrokers(Collection<IngressListenerBrokerConfiguration> items){
            if (this.brokers == null) {this.brokers = new ArrayList<IngressListenerBrokerConfigurationBuilder>();}
            for (IngressListenerBrokerConfiguration item : items) {IngressListenerBrokerConfigurationBuilder builder = new IngressListenerBrokerConfigurationBuilder(item);_visitables.get("brokers").add(builder);this.brokers.add(builder);} return (A)this;
    }

    public A removeFromBrokers(IngressListenerBrokerConfiguration... items){
            for (IngressListenerBrokerConfiguration item : items) {IngressListenerBrokerConfigurationBuilder builder = new IngressListenerBrokerConfigurationBuilder(item);_visitables.get("brokers").remove(builder);if (this.brokers != null) {this.brokers.remove(builder);}} return (A)this;
    }

    public A removeAllFromBrokers(Collection<IngressListenerBrokerConfiguration> items){
            for (IngressListenerBrokerConfiguration item : items) {IngressListenerBrokerConfigurationBuilder builder = new IngressListenerBrokerConfigurationBuilder(item);_visitables.get("brokers").remove(builder);if (this.brokers != null) {this.brokers.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromBrokers(io.fabric8.kubernetes.api.builder.Predicate<IngressListenerBrokerConfigurationBuilder> predicate){
            if (brokers == null) return (A) this;
            final Iterator<IngressListenerBrokerConfigurationBuilder> each = brokers.iterator();
            final List visitables = _visitables.get("brokers");
            while (each.hasNext()) {
              IngressListenerBrokerConfigurationBuilder builder = each.next();
              if (predicate.apply(builder)) {
                visitables.remove(builder);
                each.remove();
              }
            }
            return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildBrokers instead.
 * @return The buildable object.
 */
@Deprecated public java.util.List<IngressListenerBrokerConfiguration> getBrokers(){
            return build(brokers);
    }

    public java.util.List<IngressListenerBrokerConfiguration> buildBrokers(){
            return build(brokers);
    }

    public IngressListenerBrokerConfiguration buildBroker(int index){
            return this.brokers.get(index).build();
    }

    public IngressListenerBrokerConfiguration buildFirstBroker(){
            return this.brokers.get(0).build();
    }

    public IngressListenerBrokerConfiguration buildLastBroker(){
            return this.brokers.get(brokers.size() - 1).build();
    }

    public IngressListenerBrokerConfiguration buildMatchingBroker(io.fabric8.kubernetes.api.builder.Predicate<IngressListenerBrokerConfigurationBuilder> predicate){
            for (IngressListenerBrokerConfigurationBuilder item: brokers) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingBroker(io.fabric8.kubernetes.api.builder.Predicate<IngressListenerBrokerConfigurationBuilder> predicate){
            for (IngressListenerBrokerConfigurationBuilder item: brokers) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withBrokers(java.util.List<IngressListenerBrokerConfiguration> brokers){
            if (this.brokers != null) { _visitables.get("brokers").removeAll(this.brokers);}
            if (brokers != null) {this.brokers = new ArrayList<IngressListenerBrokerConfigurationBuilder>(); for (IngressListenerBrokerConfiguration item : brokers){this.addToBrokers(item);}} else { this.brokers = null;} return (A) this;
    }

    public A withBrokers(IngressListenerBrokerConfiguration... brokers){
            if (this.brokers != null) {this.brokers.clear();}
            if (brokers != null) {for (IngressListenerBrokerConfiguration item :brokers){ this.addToBrokers(item);}} return (A) this;
    }

    public Boolean hasBrokers(){
            return brokers != null && !brokers.isEmpty();
    }

    public IngressListenerConfigurationFluent.BrokersNested<A> addNewBroker(){
            return new BrokersNestedImpl();
    }

    public IngressListenerConfigurationFluent.BrokersNested<A> addNewBrokerLike(IngressListenerBrokerConfiguration item){
            return new BrokersNestedImpl(-1, item);
    }

    public IngressListenerConfigurationFluent.BrokersNested<A> setNewBrokerLike(int index,IngressListenerBrokerConfiguration item){
            return new BrokersNestedImpl(index, item);
    }

    public IngressListenerConfigurationFluent.BrokersNested<A> editBroker(int index){
            if (brokers.size() <= index) throw new RuntimeException("Can't edit brokers. Index exceeds size.");
            return setNewBrokerLike(index, buildBroker(index));
    }

    public IngressListenerConfigurationFluent.BrokersNested<A> editFirstBroker(){
            if (brokers.size() == 0) throw new RuntimeException("Can't edit first brokers. The list is empty.");
            return setNewBrokerLike(0, buildBroker(0));
    }

    public IngressListenerConfigurationFluent.BrokersNested<A> editLastBroker(){
            int index = brokers.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last brokers. The list is empty.");
            return setNewBrokerLike(index, buildBroker(index));
    }

    public IngressListenerConfigurationFluent.BrokersNested<A> editMatchingBroker(io.fabric8.kubernetes.api.builder.Predicate<IngressListenerBrokerConfigurationBuilder> predicate){
            int index = -1;
            for (int i=0;i<brokers.size();i++) { 
            if (predicate.apply(brokers.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching brokers. No match found.");
            return setNewBrokerLike(index, buildBroker(index));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            IngressListenerConfigurationFluentImpl that = (IngressListenerConfigurationFluentImpl) o;
            if (bootstrap != null ? !bootstrap.equals(that.bootstrap) :that.bootstrap != null) return false;
            if (brokers != null ? !brokers.equals(that.brokers) :that.brokers != null) return false;
            return true;
    }


    public class BootstrapNestedImpl<N> extends IngressListenerBootstrapConfigurationFluentImpl<IngressListenerConfigurationFluent.BootstrapNested<N>> implements IngressListenerConfigurationFluent.BootstrapNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final IngressListenerBootstrapConfigurationBuilder builder;
    
            BootstrapNestedImpl(IngressListenerBootstrapConfiguration item){
                    this.builder = new IngressListenerBootstrapConfigurationBuilder(this, item);
            }
            BootstrapNestedImpl(){
                    this.builder = new IngressListenerBootstrapConfigurationBuilder(this);
            }
    
    public N and(){
            return (N) IngressListenerConfigurationFluentImpl.this.withBootstrap(builder.build());
    }
    public N endBootstrap(){
            return and();
    }

}
    public class BrokersNestedImpl<N> extends IngressListenerBrokerConfigurationFluentImpl<IngressListenerConfigurationFluent.BrokersNested<N>> implements IngressListenerConfigurationFluent.BrokersNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final IngressListenerBrokerConfigurationBuilder builder;
        private final int index;
    
            BrokersNestedImpl(int index,IngressListenerBrokerConfiguration item){
                    this.index = index;
                    this.builder = new IngressListenerBrokerConfigurationBuilder(this, item);
            }
            BrokersNestedImpl(){
                    this.index = -1;
                    this.builder = new IngressListenerBrokerConfigurationBuilder(this);
            }
    
    public N and(){
            return (N) IngressListenerConfigurationFluentImpl.this.setToBrokers(index, builder.build());
    }
    public N endBroker(){
            return and();
    }

}


}
