package io.strimzi.api.kafka.model.listener;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class KafkaListenerExternalConfigurationBuilder extends KafkaListenerExternalConfigurationFluentImpl<KafkaListenerExternalConfigurationBuilder> implements VisitableBuilder<KafkaListenerExternalConfiguration,KafkaListenerExternalConfigurationBuilder>{

    KafkaListenerExternalConfigurationFluent<?> fluent;
    Boolean validationEnabled;

    public KafkaListenerExternalConfigurationBuilder(){
            this(true);
    }
    public KafkaListenerExternalConfigurationBuilder(Boolean validationEnabled){
            this(new KafkaListenerExternalConfiguration(), validationEnabled);
    }
    public KafkaListenerExternalConfigurationBuilder(KafkaListenerExternalConfigurationFluent<?> fluent){
            this(fluent, true);
    }
    public KafkaListenerExternalConfigurationBuilder(KafkaListenerExternalConfigurationFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new KafkaListenerExternalConfiguration(), validationEnabled);
    }
    public KafkaListenerExternalConfigurationBuilder(KafkaListenerExternalConfigurationFluent<?> fluent,KafkaListenerExternalConfiguration instance){
            this(fluent, instance, true);
    }
    public KafkaListenerExternalConfigurationBuilder(KafkaListenerExternalConfigurationFluent<?> fluent,KafkaListenerExternalConfiguration instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withBrokerCertChainAndKey(instance.getBrokerCertChainAndKey());

            this.validationEnabled = validationEnabled; 
    }
    public KafkaListenerExternalConfigurationBuilder(KafkaListenerExternalConfiguration instance){
            this(instance,true);
    }
    public KafkaListenerExternalConfigurationBuilder(KafkaListenerExternalConfiguration instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withBrokerCertChainAndKey(instance.getBrokerCertChainAndKey());

            this.validationEnabled = validationEnabled; 
    }

    public KafkaListenerExternalConfiguration build(){
            KafkaListenerExternalConfiguration buildable = new KafkaListenerExternalConfiguration();
            buildable.setBrokerCertChainAndKey(fluent.getBrokerCertChainAndKey());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            KafkaListenerExternalConfigurationBuilder that = (KafkaListenerExternalConfigurationBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
