package io.strimzi.api.kafka.model.listener;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class KafkaListenerExternalIngressBuilder extends KafkaListenerExternalIngressFluentImpl<KafkaListenerExternalIngressBuilder> implements VisitableBuilder<KafkaListenerExternalIngress,KafkaListenerExternalIngressBuilder>{

    KafkaListenerExternalIngressFluent<?> fluent;
    Boolean validationEnabled;

    public KafkaListenerExternalIngressBuilder(){
            this(true);
    }
    public KafkaListenerExternalIngressBuilder(Boolean validationEnabled){
            this(new KafkaListenerExternalIngress(), validationEnabled);
    }
    public KafkaListenerExternalIngressBuilder(KafkaListenerExternalIngressFluent<?> fluent){
            this(fluent, true);
    }
    public KafkaListenerExternalIngressBuilder(KafkaListenerExternalIngressFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new KafkaListenerExternalIngress(), validationEnabled);
    }
    public KafkaListenerExternalIngressBuilder(KafkaListenerExternalIngressFluent<?> fluent,KafkaListenerExternalIngress instance){
            this(fluent, instance, true);
    }
    public KafkaListenerExternalIngressBuilder(KafkaListenerExternalIngressFluent<?> fluent,KafkaListenerExternalIngress instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withAuth(instance.getAuth());

            fluent.withNetworkPolicyPeers(instance.getNetworkPolicyPeers());

            fluent.withConfiguration(instance.getConfiguration());

            fluent.withIngressClass(instance.getIngressClass());

            this.validationEnabled = validationEnabled; 
    }
    public KafkaListenerExternalIngressBuilder(KafkaListenerExternalIngress instance){
            this(instance,true);
    }
    public KafkaListenerExternalIngressBuilder(KafkaListenerExternalIngress instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withAuth(instance.getAuth());

            this.withNetworkPolicyPeers(instance.getNetworkPolicyPeers());

            this.withConfiguration(instance.getConfiguration());

            this.withIngressClass(instance.getIngressClass());

            this.validationEnabled = validationEnabled; 
    }

    public KafkaListenerExternalIngress build(){
            KafkaListenerExternalIngress buildable = new KafkaListenerExternalIngress();
            buildable.setAuth(fluent.getAuth());
            buildable.setNetworkPolicyPeers(fluent.getNetworkPolicyPeers());
            buildable.setConfiguration(fluent.getConfiguration());
            buildable.setIngressClass(fluent.getIngressClass());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            KafkaListenerExternalIngressBuilder that = (KafkaListenerExternalIngressBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
