package io.strimzi.api.kafka.model.listener;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPeer;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import java.lang.StringBuffer;
import java.util.Collection;
import java.lang.Object;

public class KafkaListenerExternalIngressFluentImpl<A extends KafkaListenerExternalIngressFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements KafkaListenerExternalIngressFluent<A>{

    private VisitableBuilder<? extends KafkaListenerAuthentication,?> auth;
    private java.util.List<NetworkPolicyPeer> networkPolicyPeers;
    private IngressListenerConfigurationBuilder configuration;
    private String ingressClass;

    public KafkaListenerExternalIngressFluentImpl(){
    }
    public KafkaListenerExternalIngressFluentImpl(KafkaListenerExternalIngress instance){
            this.withAuth(instance.getAuth());

            this.withNetworkPolicyPeers(instance.getNetworkPolicyPeers());

            this.withConfiguration(instance.getConfiguration());

            this.withIngressClass(instance.getIngressClass());

    }

    
/**
 * This method has been deprecated, please use method buildAuth instead.
 * @return The buildable object.
 */
@Deprecated public KafkaListenerAuthentication getAuth(){
            return this.auth!=null?this.auth.build():null;
    }

    public KafkaListenerAuthentication buildAuth(){
            return this.auth!=null?this.auth.build():null;
    }

    public A withAuth(KafkaListenerAuthentication auth){
            _visitables.get("auth").remove(this.auth);
            if (auth instanceof KafkaListenerAuthenticationOAuth){ this.auth= new KafkaListenerAuthenticationOAuthBuilder((KafkaListenerAuthenticationOAuth)auth); _visitables.get("auth").add(this.auth);}
            if (auth instanceof KafkaListenerAuthenticationTls){ this.auth= new KafkaListenerAuthenticationTlsBuilder((KafkaListenerAuthenticationTls)auth); _visitables.get("auth").add(this.auth);}
            if (auth instanceof KafkaListenerAuthenticationScramSha512){ this.auth= new KafkaListenerAuthenticationScramSha512Builder((KafkaListenerAuthenticationScramSha512)auth); _visitables.get("auth").add(this.auth);}
            return (A) this;
    }

    public Boolean hasAuth(){
            return this.auth != null;
    }

    public A withKafkaListenerAuthenticationOAuth(KafkaListenerAuthenticationOAuth kafkaListenerAuthenticationOAuth){
            _visitables.get("auth").remove(this.auth);
            if (kafkaListenerAuthenticationOAuth!=null){ this.auth= new KafkaListenerAuthenticationOAuthBuilder(kafkaListenerAuthenticationOAuth); _visitables.get("auth").add(this.auth);} return (A) this;
    }

    public KafkaListenerExternalIngressFluent.KafkaListenerAuthenticationOAuthNested<A> withNewKafkaListenerAuthenticationOAuth(){
            return new KafkaListenerAuthenticationOAuthNestedImpl();
    }

    public KafkaListenerExternalIngressFluent.KafkaListenerAuthenticationOAuthNested<A> withNewKafkaListenerAuthenticationOAuthLike(KafkaListenerAuthenticationOAuth item){
            return new KafkaListenerAuthenticationOAuthNestedImpl(item);
    }

    public A withKafkaListenerAuthenticationTlsAuth(KafkaListenerAuthenticationTls kafkaListenerAuthenticationTlsAuth){
            _visitables.get("auth").remove(this.auth);
            if (kafkaListenerAuthenticationTlsAuth!=null){ this.auth= new KafkaListenerAuthenticationTlsBuilder(kafkaListenerAuthenticationTlsAuth); _visitables.get("auth").add(this.auth);} return (A) this;
    }

    public KafkaListenerExternalIngressFluent.KafkaListenerAuthenticationTlsAuthNested<A> withNewKafkaListenerAuthenticationTlsAuth(){
            return new KafkaListenerAuthenticationTlsAuthNestedImpl();
    }

    public KafkaListenerExternalIngressFluent.KafkaListenerAuthenticationTlsAuthNested<A> withNewKafkaListenerAuthenticationTlsAuthLike(KafkaListenerAuthenticationTls item){
            return new KafkaListenerAuthenticationTlsAuthNestedImpl(item);
    }

    public A withKafkaListenerAuthenticationScramSha512Auth(KafkaListenerAuthenticationScramSha512 kafkaListenerAuthenticationScramSha512Auth){
            _visitables.get("auth").remove(this.auth);
            if (kafkaListenerAuthenticationScramSha512Auth!=null){ this.auth= new KafkaListenerAuthenticationScramSha512Builder(kafkaListenerAuthenticationScramSha512Auth); _visitables.get("auth").add(this.auth);} return (A) this;
    }

    public KafkaListenerExternalIngressFluent.KafkaListenerAuthenticationScramSha512AuthNested<A> withNewKafkaListenerAuthenticationScramSha512Auth(){
            return new KafkaListenerAuthenticationScramSha512AuthNestedImpl();
    }

    public KafkaListenerExternalIngressFluent.KafkaListenerAuthenticationScramSha512AuthNested<A> withNewKafkaListenerAuthenticationScramSha512AuthLike(KafkaListenerAuthenticationScramSha512 item){
            return new KafkaListenerAuthenticationScramSha512AuthNestedImpl(item);
    }

    public A addToNetworkPolicyPeers(int index,NetworkPolicyPeer item){
            if (this.networkPolicyPeers == null) {this.networkPolicyPeers = new ArrayList<NetworkPolicyPeer>();}
            this.networkPolicyPeers.add(index, item);
            return (A)this;
    }

    public A setToNetworkPolicyPeers(int index,NetworkPolicyPeer item){
            if (this.networkPolicyPeers == null) {this.networkPolicyPeers = new ArrayList<NetworkPolicyPeer>();}
            this.networkPolicyPeers.set(index, item); return (A)this;
    }

    public A addToNetworkPolicyPeers(NetworkPolicyPeer... items){
            if (this.networkPolicyPeers == null) {this.networkPolicyPeers = new ArrayList<NetworkPolicyPeer>();}
            for (NetworkPolicyPeer item : items) {this.networkPolicyPeers.add(item);} return (A)this;
    }

    public A addAllToNetworkPolicyPeers(Collection<NetworkPolicyPeer> items){
            if (this.networkPolicyPeers == null) {this.networkPolicyPeers = new ArrayList<NetworkPolicyPeer>();}
            for (NetworkPolicyPeer item : items) {this.networkPolicyPeers.add(item);} return (A)this;
    }

    public A removeFromNetworkPolicyPeers(NetworkPolicyPeer... items){
            for (NetworkPolicyPeer item : items) {if (this.networkPolicyPeers!= null){ this.networkPolicyPeers.remove(item);}} return (A)this;
    }

    public A removeAllFromNetworkPolicyPeers(Collection<NetworkPolicyPeer> items){
            for (NetworkPolicyPeer item : items) {if (this.networkPolicyPeers!= null){ this.networkPolicyPeers.remove(item);}} return (A)this;
    }

    public java.util.List<NetworkPolicyPeer> getNetworkPolicyPeers(){
            return this.networkPolicyPeers;
    }

    public NetworkPolicyPeer getNetworkPolicyPeer(int index){
            return this.networkPolicyPeers.get(index);
    }

    public NetworkPolicyPeer getFirstNetworkPolicyPeer(){
            return this.networkPolicyPeers.get(0);
    }

    public NetworkPolicyPeer getLastNetworkPolicyPeer(){
            return this.networkPolicyPeers.get(networkPolicyPeers.size() - 1);
    }

    public NetworkPolicyPeer getMatchingNetworkPolicyPeer(io.fabric8.kubernetes.api.builder.Predicate<NetworkPolicyPeer> predicate){
            for (NetworkPolicyPeer item: networkPolicyPeers) { if(predicate.apply(item)){ return item;} } return null;
    }

    public Boolean hasMatchingNetworkPolicyPeer(io.fabric8.kubernetes.api.builder.Predicate<NetworkPolicyPeer> predicate){
            for (NetworkPolicyPeer item: networkPolicyPeers) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withNetworkPolicyPeers(java.util.List<NetworkPolicyPeer> networkPolicyPeers){
            if (this.networkPolicyPeers != null) { _visitables.get("networkPolicyPeers").removeAll(this.networkPolicyPeers);}
            if (networkPolicyPeers != null) {this.networkPolicyPeers = new ArrayList<NetworkPolicyPeer>(); for (NetworkPolicyPeer item : networkPolicyPeers){this.addToNetworkPolicyPeers(item);}} else { this.networkPolicyPeers = null;} return (A) this;
    }

    public A withNetworkPolicyPeers(NetworkPolicyPeer... networkPolicyPeers){
            if (this.networkPolicyPeers != null) {this.networkPolicyPeers.clear();}
            if (networkPolicyPeers != null) {for (NetworkPolicyPeer item :networkPolicyPeers){ this.addToNetworkPolicyPeers(item);}} return (A) this;
    }

    public Boolean hasNetworkPolicyPeers(){
            return networkPolicyPeers != null && !networkPolicyPeers.isEmpty();
    }

    
/**
 * This method has been deprecated, please use method buildConfiguration instead.
 * @return The buildable object.
 */
@Deprecated public IngressListenerConfiguration getConfiguration(){
            return this.configuration!=null?this.configuration.build():null;
    }

    public IngressListenerConfiguration buildConfiguration(){
            return this.configuration!=null?this.configuration.build():null;
    }

    public A withConfiguration(IngressListenerConfiguration configuration){
            _visitables.get("configuration").remove(this.configuration);
            if (configuration!=null){ this.configuration= new IngressListenerConfigurationBuilder(configuration); _visitables.get("configuration").add(this.configuration);} return (A) this;
    }

    public Boolean hasConfiguration(){
            return this.configuration != null;
    }

    public KafkaListenerExternalIngressFluent.ConfigurationNested<A> withNewConfiguration(){
            return new ConfigurationNestedImpl();
    }

    public KafkaListenerExternalIngressFluent.ConfigurationNested<A> withNewConfigurationLike(IngressListenerConfiguration item){
            return new ConfigurationNestedImpl(item);
    }

    public KafkaListenerExternalIngressFluent.ConfigurationNested<A> editConfiguration(){
            return withNewConfigurationLike(getConfiguration());
    }

    public KafkaListenerExternalIngressFluent.ConfigurationNested<A> editOrNewConfiguration(){
            return withNewConfigurationLike(getConfiguration() != null ? getConfiguration(): new IngressListenerConfigurationBuilder().build());
    }

    public KafkaListenerExternalIngressFluent.ConfigurationNested<A> editOrNewConfigurationLike(IngressListenerConfiguration item){
            return withNewConfigurationLike(getConfiguration() != null ? getConfiguration(): item);
    }

    public String getIngressClass(){
            return this.ingressClass;
    }

    public A withIngressClass(String ingressClass){
            this.ingressClass=ingressClass; return (A) this;
    }

    public Boolean hasIngressClass(){
            return this.ingressClass != null;
    }

    public A withNewIngressClass(String arg1){
            return (A)withIngressClass(new String(arg1));
    }

    public A withNewIngressClass(StringBuilder arg1){
            return (A)withIngressClass(new String(arg1));
    }

    public A withNewIngressClass(StringBuffer arg1){
            return (A)withIngressClass(new String(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            KafkaListenerExternalIngressFluentImpl that = (KafkaListenerExternalIngressFluentImpl) o;
            if (auth != null ? !auth.equals(that.auth) :that.auth != null) return false;
            if (networkPolicyPeers != null ? !networkPolicyPeers.equals(that.networkPolicyPeers) :that.networkPolicyPeers != null) return false;
            if (configuration != null ? !configuration.equals(that.configuration) :that.configuration != null) return false;
            if (ingressClass != null ? !ingressClass.equals(that.ingressClass) :that.ingressClass != null) return false;
            return true;
    }


    public class KafkaListenerAuthenticationOAuthNestedImpl<N> extends KafkaListenerAuthenticationOAuthFluentImpl<KafkaListenerExternalIngressFluent.KafkaListenerAuthenticationOAuthNested<N>> implements KafkaListenerExternalIngressFluent.KafkaListenerAuthenticationOAuthNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final KafkaListenerAuthenticationOAuthBuilder builder;
    
            KafkaListenerAuthenticationOAuthNestedImpl(KafkaListenerAuthenticationOAuth item){
                    this.builder = new KafkaListenerAuthenticationOAuthBuilder(this, item);
            }
            KafkaListenerAuthenticationOAuthNestedImpl(){
                    this.builder = new KafkaListenerAuthenticationOAuthBuilder(this);
            }
    
    public N and(){
            return (N) KafkaListenerExternalIngressFluentImpl.this.withKafkaListenerAuthenticationOAuth(builder.build());
    }
    public N endKafkaListenerAuthenticationOAuth(){
            return and();
    }

}
    public class KafkaListenerAuthenticationTlsAuthNestedImpl<N> extends KafkaListenerAuthenticationTlsFluentImpl<KafkaListenerExternalIngressFluent.KafkaListenerAuthenticationTlsAuthNested<N>> implements KafkaListenerExternalIngressFluent.KafkaListenerAuthenticationTlsAuthNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final KafkaListenerAuthenticationTlsBuilder builder;
    
            KafkaListenerAuthenticationTlsAuthNestedImpl(KafkaListenerAuthenticationTls item){
                    this.builder = new KafkaListenerAuthenticationTlsBuilder(this, item);
            }
            KafkaListenerAuthenticationTlsAuthNestedImpl(){
                    this.builder = new KafkaListenerAuthenticationTlsBuilder(this);
            }
    
    public N and(){
            return (N) KafkaListenerExternalIngressFluentImpl.this.withKafkaListenerAuthenticationTlsAuth(builder.build());
    }
    public N endKafkaListenerAuthenticationTlsAuth(){
            return and();
    }

}
    public class KafkaListenerAuthenticationScramSha512AuthNestedImpl<N> extends KafkaListenerAuthenticationScramSha512FluentImpl<KafkaListenerExternalIngressFluent.KafkaListenerAuthenticationScramSha512AuthNested<N>> implements KafkaListenerExternalIngressFluent.KafkaListenerAuthenticationScramSha512AuthNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final KafkaListenerAuthenticationScramSha512Builder builder;
    
            KafkaListenerAuthenticationScramSha512AuthNestedImpl(KafkaListenerAuthenticationScramSha512 item){
                    this.builder = new KafkaListenerAuthenticationScramSha512Builder(this, item);
            }
            KafkaListenerAuthenticationScramSha512AuthNestedImpl(){
                    this.builder = new KafkaListenerAuthenticationScramSha512Builder(this);
            }
    
    public N and(){
            return (N) KafkaListenerExternalIngressFluentImpl.this.withKafkaListenerAuthenticationScramSha512Auth(builder.build());
    }
    public N endKafkaListenerAuthenticationScramSha512Auth(){
            return and();
    }

}
    public class ConfigurationNestedImpl<N> extends IngressListenerConfigurationFluentImpl<KafkaListenerExternalIngressFluent.ConfigurationNested<N>> implements KafkaListenerExternalIngressFluent.ConfigurationNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final IngressListenerConfigurationBuilder builder;
    
            ConfigurationNestedImpl(IngressListenerConfiguration item){
                    this.builder = new IngressListenerConfigurationBuilder(this, item);
            }
            ConfigurationNestedImpl(){
                    this.builder = new IngressListenerConfigurationBuilder(this);
            }
    
    public N and(){
            return (N) KafkaListenerExternalIngressFluentImpl.this.withConfiguration(builder.build());
    }
    public N endConfiguration(){
            return and();
    }

}


}
