package io.strimzi.api.kafka.model.listener;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class KafkaListenerExternalLoadBalancerBuilder extends KafkaListenerExternalLoadBalancerFluentImpl<KafkaListenerExternalLoadBalancerBuilder> implements VisitableBuilder<KafkaListenerExternalLoadBalancer,KafkaListenerExternalLoadBalancerBuilder>{

    KafkaListenerExternalLoadBalancerFluent<?> fluent;
    Boolean validationEnabled;

    public KafkaListenerExternalLoadBalancerBuilder(){
            this(true);
    }
    public KafkaListenerExternalLoadBalancerBuilder(Boolean validationEnabled){
            this(new KafkaListenerExternalLoadBalancer(), validationEnabled);
    }
    public KafkaListenerExternalLoadBalancerBuilder(KafkaListenerExternalLoadBalancerFluent<?> fluent){
            this(fluent, true);
    }
    public KafkaListenerExternalLoadBalancerBuilder(KafkaListenerExternalLoadBalancerFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new KafkaListenerExternalLoadBalancer(), validationEnabled);
    }
    public KafkaListenerExternalLoadBalancerBuilder(KafkaListenerExternalLoadBalancerFluent<?> fluent,KafkaListenerExternalLoadBalancer instance){
            this(fluent, instance, true);
    }
    public KafkaListenerExternalLoadBalancerBuilder(KafkaListenerExternalLoadBalancerFluent<?> fluent,KafkaListenerExternalLoadBalancer instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withAuth(instance.getAuth());

            fluent.withTls(instance.isTls());

            fluent.withNetworkPolicyPeers(instance.getNetworkPolicyPeers());

            fluent.withOverrides(instance.getOverrides());

            fluent.withConfiguration(instance.getConfiguration());

            this.validationEnabled = validationEnabled; 
    }
    public KafkaListenerExternalLoadBalancerBuilder(KafkaListenerExternalLoadBalancer instance){
            this(instance,true);
    }
    public KafkaListenerExternalLoadBalancerBuilder(KafkaListenerExternalLoadBalancer instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withAuth(instance.getAuth());

            this.withTls(instance.isTls());

            this.withNetworkPolicyPeers(instance.getNetworkPolicyPeers());

            this.withOverrides(instance.getOverrides());

            this.withConfiguration(instance.getConfiguration());

            this.validationEnabled = validationEnabled; 
    }

    public KafkaListenerExternalLoadBalancer build(){
            KafkaListenerExternalLoadBalancer buildable = new KafkaListenerExternalLoadBalancer();
            buildable.setAuth(fluent.getAuth());
            buildable.setTls(fluent.isTls());
            buildable.setNetworkPolicyPeers(fluent.getNetworkPolicyPeers());
            buildable.setOverrides(fluent.getOverrides());
            buildable.setConfiguration(fluent.getConfiguration());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            KafkaListenerExternalLoadBalancerBuilder that = (KafkaListenerExternalLoadBalancerBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
