package io.strimzi.api.kafka.model.listener;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class NodePortListenerBootstrapOverrideBuilder extends NodePortListenerBootstrapOverrideFluentImpl<NodePortListenerBootstrapOverrideBuilder> implements VisitableBuilder<NodePortListenerBootstrapOverride,NodePortListenerBootstrapOverrideBuilder>{

    NodePortListenerBootstrapOverrideFluent<?> fluent;
    Boolean validationEnabled;

    public NodePortListenerBootstrapOverrideBuilder(){
            this(true);
    }
    public NodePortListenerBootstrapOverrideBuilder(Boolean validationEnabled){
            this(new NodePortListenerBootstrapOverride(), validationEnabled);
    }
    public NodePortListenerBootstrapOverrideBuilder(NodePortListenerBootstrapOverrideFluent<?> fluent){
            this(fluent, true);
    }
    public NodePortListenerBootstrapOverrideBuilder(NodePortListenerBootstrapOverrideFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new NodePortListenerBootstrapOverride(), validationEnabled);
    }
    public NodePortListenerBootstrapOverrideBuilder(NodePortListenerBootstrapOverrideFluent<?> fluent,NodePortListenerBootstrapOverride instance){
            this(fluent, instance, true);
    }
    public NodePortListenerBootstrapOverrideBuilder(NodePortListenerBootstrapOverrideFluent<?> fluent,NodePortListenerBootstrapOverride instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withNodePort(instance.getNodePort());

            fluent.withDnsAnnotations(instance.getDnsAnnotations());

            fluent.withAddress(instance.getAddress());

            this.validationEnabled = validationEnabled; 
    }
    public NodePortListenerBootstrapOverrideBuilder(NodePortListenerBootstrapOverride instance){
            this(instance,true);
    }
    public NodePortListenerBootstrapOverrideBuilder(NodePortListenerBootstrapOverride instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withNodePort(instance.getNodePort());

            this.withDnsAnnotations(instance.getDnsAnnotations());

            this.withAddress(instance.getAddress());

            this.validationEnabled = validationEnabled; 
    }

    public NodePortListenerBootstrapOverride build(){
            NodePortListenerBootstrapOverride buildable = new NodePortListenerBootstrapOverride();
            buildable.setAddress(fluent.getAddress());
            buildable.setNodePort(fluent.getNodePort());
            buildable.setDnsAnnotations(fluent.getDnsAnnotations());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            NodePortListenerBootstrapOverrideBuilder that = (NodePortListenerBootstrapOverrideBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
