package io.strimzi.api.kafka.model.listener;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class NodePortListenerBrokerOverrideBuilder extends NodePortListenerBrokerOverrideFluentImpl<NodePortListenerBrokerOverrideBuilder> implements VisitableBuilder<NodePortListenerBrokerOverride,NodePortListenerBrokerOverrideBuilder>{

    NodePortListenerBrokerOverrideFluent<?> fluent;
    Boolean validationEnabled;

    public NodePortListenerBrokerOverrideBuilder(){
            this(true);
    }
    public NodePortListenerBrokerOverrideBuilder(Boolean validationEnabled){
            this(new NodePortListenerBrokerOverride(), validationEnabled);
    }
    public NodePortListenerBrokerOverrideBuilder(NodePortListenerBrokerOverrideFluent<?> fluent){
            this(fluent, true);
    }
    public NodePortListenerBrokerOverrideBuilder(NodePortListenerBrokerOverrideFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new NodePortListenerBrokerOverride(), validationEnabled);
    }
    public NodePortListenerBrokerOverrideBuilder(NodePortListenerBrokerOverrideFluent<?> fluent,NodePortListenerBrokerOverride instance){
            this(fluent, instance, true);
    }
    public NodePortListenerBrokerOverrideBuilder(NodePortListenerBrokerOverrideFluent<?> fluent,NodePortListenerBrokerOverride instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withNodePort(instance.getNodePort());

            fluent.withDnsAnnotations(instance.getDnsAnnotations());

            fluent.withBroker(instance.getBroker());

            fluent.withAdvertisedHost(instance.getAdvertisedHost());

            fluent.withAdvertisedPort(instance.getAdvertisedPort());

            this.validationEnabled = validationEnabled; 
    }
    public NodePortListenerBrokerOverrideBuilder(NodePortListenerBrokerOverride instance){
            this(instance,true);
    }
    public NodePortListenerBrokerOverrideBuilder(NodePortListenerBrokerOverride instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withNodePort(instance.getNodePort());

            this.withDnsAnnotations(instance.getDnsAnnotations());

            this.withBroker(instance.getBroker());

            this.withAdvertisedHost(instance.getAdvertisedHost());

            this.withAdvertisedPort(instance.getAdvertisedPort());

            this.validationEnabled = validationEnabled; 
    }

    public NodePortListenerBrokerOverride build(){
            NodePortListenerBrokerOverride buildable = new NodePortListenerBrokerOverride();
            buildable.setBroker(fluent.getBroker());
            buildable.setAdvertisedHost(fluent.getAdvertisedHost());
            buildable.setAdvertisedPort(fluent.getAdvertisedPort());
            buildable.setNodePort(fluent.getNodePort());
            buildable.setDnsAnnotations(fluent.getDnsAnnotations());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            NodePortListenerBrokerOverrideBuilder that = (NodePortListenerBrokerOverrideBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
