package io.strimzi.api.kafka.model.listener;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class NodePortListenerOverrideFluentImpl<A extends NodePortListenerOverrideFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements NodePortListenerOverrideFluent<A>{

    private NodePortListenerBootstrapOverrideBuilder bootstrap;
    private java.util.List<NodePortListenerBrokerOverrideBuilder> brokers;

    public NodePortListenerOverrideFluentImpl(){
    }
    public NodePortListenerOverrideFluentImpl(NodePortListenerOverride instance){
            this.withBootstrap(instance.getBootstrap());

            this.withBrokers(instance.getBrokers());

    }

    
/**
 * This method has been deprecated, please use method buildBootstrap instead.
 * @return The buildable object.
 */
@Deprecated public NodePortListenerBootstrapOverride getBootstrap(){
            return this.bootstrap!=null?this.bootstrap.build():null;
    }

    public NodePortListenerBootstrapOverride buildBootstrap(){
            return this.bootstrap!=null?this.bootstrap.build():null;
    }

    public A withBootstrap(NodePortListenerBootstrapOverride bootstrap){
            _visitables.get("bootstrap").remove(this.bootstrap);
            if (bootstrap!=null){ this.bootstrap= new NodePortListenerBootstrapOverrideBuilder(bootstrap); _visitables.get("bootstrap").add(this.bootstrap);} return (A) this;
    }

    public Boolean hasBootstrap(){
            return this.bootstrap != null;
    }

    public NodePortListenerOverrideFluent.BootstrapNested<A> withNewBootstrap(){
            return new BootstrapNestedImpl();
    }

    public NodePortListenerOverrideFluent.BootstrapNested<A> withNewBootstrapLike(NodePortListenerBootstrapOverride item){
            return new BootstrapNestedImpl(item);
    }

    public NodePortListenerOverrideFluent.BootstrapNested<A> editBootstrap(){
            return withNewBootstrapLike(getBootstrap());
    }

    public NodePortListenerOverrideFluent.BootstrapNested<A> editOrNewBootstrap(){
            return withNewBootstrapLike(getBootstrap() != null ? getBootstrap(): new NodePortListenerBootstrapOverrideBuilder().build());
    }

    public NodePortListenerOverrideFluent.BootstrapNested<A> editOrNewBootstrapLike(NodePortListenerBootstrapOverride item){
            return withNewBootstrapLike(getBootstrap() != null ? getBootstrap(): item);
    }

    public A addToBrokers(int index,NodePortListenerBrokerOverride item){
            if (this.brokers == null) {this.brokers = new ArrayList<NodePortListenerBrokerOverrideBuilder>();}
            NodePortListenerBrokerOverrideBuilder builder = new NodePortListenerBrokerOverrideBuilder(item);_visitables.get("brokers").add(index >= 0 ? index : _visitables.get("brokers").size(), builder);this.brokers.add(index >= 0 ? index : brokers.size(), builder); return (A)this;
    }

    public A setToBrokers(int index,NodePortListenerBrokerOverride item){
            if (this.brokers == null) {this.brokers = new ArrayList<NodePortListenerBrokerOverrideBuilder>();}
            NodePortListenerBrokerOverrideBuilder builder = new NodePortListenerBrokerOverrideBuilder(item);
            if (index < 0 || index >= _visitables.get("brokers").size()) { _visitables.get("brokers").add(builder); } else { _visitables.get("brokers").set(index, builder);}
            if (index < 0 || index >= brokers.size()) { brokers.add(builder); } else { brokers.set(index, builder);}
             return (A)this;
    }

    public A addToBrokers(NodePortListenerBrokerOverride... items){
            if (this.brokers == null) {this.brokers = new ArrayList<NodePortListenerBrokerOverrideBuilder>();}
            for (NodePortListenerBrokerOverride item : items) {NodePortListenerBrokerOverrideBuilder builder = new NodePortListenerBrokerOverrideBuilder(item);_visitables.get("brokers").add(builder);this.brokers.add(builder);} return (A)this;
    }

    public A addAllToBrokers(Collection<NodePortListenerBrokerOverride> items){
            if (this.brokers == null) {this.brokers = new ArrayList<NodePortListenerBrokerOverrideBuilder>();}
            for (NodePortListenerBrokerOverride item : items) {NodePortListenerBrokerOverrideBuilder builder = new NodePortListenerBrokerOverrideBuilder(item);_visitables.get("brokers").add(builder);this.brokers.add(builder);} return (A)this;
    }

    public A removeFromBrokers(NodePortListenerBrokerOverride... items){
            for (NodePortListenerBrokerOverride item : items) {NodePortListenerBrokerOverrideBuilder builder = new NodePortListenerBrokerOverrideBuilder(item);_visitables.get("brokers").remove(builder);if (this.brokers != null) {this.brokers.remove(builder);}} return (A)this;
    }

    public A removeAllFromBrokers(Collection<NodePortListenerBrokerOverride> items){
            for (NodePortListenerBrokerOverride item : items) {NodePortListenerBrokerOverrideBuilder builder = new NodePortListenerBrokerOverrideBuilder(item);_visitables.get("brokers").remove(builder);if (this.brokers != null) {this.brokers.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromBrokers(io.fabric8.kubernetes.api.builder.Predicate<NodePortListenerBrokerOverrideBuilder> predicate){
            if (brokers == null) return (A) this;
            final Iterator<NodePortListenerBrokerOverrideBuilder> each = brokers.iterator();
            final List visitables = _visitables.get("brokers");
            while (each.hasNext()) {
              NodePortListenerBrokerOverrideBuilder builder = each.next();
              if (predicate.apply(builder)) {
                visitables.remove(builder);
                each.remove();
              }
            }
            return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildBrokers instead.
 * @return The buildable object.
 */
@Deprecated public java.util.List<NodePortListenerBrokerOverride> getBrokers(){
            return build(brokers);
    }

    public java.util.List<NodePortListenerBrokerOverride> buildBrokers(){
            return build(brokers);
    }

    public NodePortListenerBrokerOverride buildBroker(int index){
            return this.brokers.get(index).build();
    }

    public NodePortListenerBrokerOverride buildFirstBroker(){
            return this.brokers.get(0).build();
    }

    public NodePortListenerBrokerOverride buildLastBroker(){
            return this.brokers.get(brokers.size() - 1).build();
    }

    public NodePortListenerBrokerOverride buildMatchingBroker(io.fabric8.kubernetes.api.builder.Predicate<NodePortListenerBrokerOverrideBuilder> predicate){
            for (NodePortListenerBrokerOverrideBuilder item: brokers) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingBroker(io.fabric8.kubernetes.api.builder.Predicate<NodePortListenerBrokerOverrideBuilder> predicate){
            for (NodePortListenerBrokerOverrideBuilder item: brokers) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withBrokers(java.util.List<NodePortListenerBrokerOverride> brokers){
            if (this.brokers != null) { _visitables.get("brokers").removeAll(this.brokers);}
            if (brokers != null) {this.brokers = new ArrayList<NodePortListenerBrokerOverrideBuilder>(); for (NodePortListenerBrokerOverride item : brokers){this.addToBrokers(item);}} else { this.brokers = null;} return (A) this;
    }

    public A withBrokers(NodePortListenerBrokerOverride... brokers){
            if (this.brokers != null) {this.brokers.clear();}
            if (brokers != null) {for (NodePortListenerBrokerOverride item :brokers){ this.addToBrokers(item);}} return (A) this;
    }

    public Boolean hasBrokers(){
            return brokers != null && !brokers.isEmpty();
    }

    public NodePortListenerOverrideFluent.BrokersNested<A> addNewBroker(){
            return new BrokersNestedImpl();
    }

    public NodePortListenerOverrideFluent.BrokersNested<A> addNewBrokerLike(NodePortListenerBrokerOverride item){
            return new BrokersNestedImpl(-1, item);
    }

    public NodePortListenerOverrideFluent.BrokersNested<A> setNewBrokerLike(int index,NodePortListenerBrokerOverride item){
            return new BrokersNestedImpl(index, item);
    }

    public NodePortListenerOverrideFluent.BrokersNested<A> editBroker(int index){
            if (brokers.size() <= index) throw new RuntimeException("Can't edit brokers. Index exceeds size.");
            return setNewBrokerLike(index, buildBroker(index));
    }

    public NodePortListenerOverrideFluent.BrokersNested<A> editFirstBroker(){
            if (brokers.size() == 0) throw new RuntimeException("Can't edit first brokers. The list is empty.");
            return setNewBrokerLike(0, buildBroker(0));
    }

    public NodePortListenerOverrideFluent.BrokersNested<A> editLastBroker(){
            int index = brokers.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last brokers. The list is empty.");
            return setNewBrokerLike(index, buildBroker(index));
    }

    public NodePortListenerOverrideFluent.BrokersNested<A> editMatchingBroker(io.fabric8.kubernetes.api.builder.Predicate<NodePortListenerBrokerOverrideBuilder> predicate){
            int index = -1;
            for (int i=0;i<brokers.size();i++) { 
            if (predicate.apply(brokers.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching brokers. No match found.");
            return setNewBrokerLike(index, buildBroker(index));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            NodePortListenerOverrideFluentImpl that = (NodePortListenerOverrideFluentImpl) o;
            if (bootstrap != null ? !bootstrap.equals(that.bootstrap) :that.bootstrap != null) return false;
            if (brokers != null ? !brokers.equals(that.brokers) :that.brokers != null) return false;
            return true;
    }


    public class BootstrapNestedImpl<N> extends NodePortListenerBootstrapOverrideFluentImpl<NodePortListenerOverrideFluent.BootstrapNested<N>> implements NodePortListenerOverrideFluent.BootstrapNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final NodePortListenerBootstrapOverrideBuilder builder;
    
            BootstrapNestedImpl(NodePortListenerBootstrapOverride item){
                    this.builder = new NodePortListenerBootstrapOverrideBuilder(this, item);
            }
            BootstrapNestedImpl(){
                    this.builder = new NodePortListenerBootstrapOverrideBuilder(this);
            }
    
    public N and(){
            return (N) NodePortListenerOverrideFluentImpl.this.withBootstrap(builder.build());
    }
    public N endBootstrap(){
            return and();
    }

}
    public class BrokersNestedImpl<N> extends NodePortListenerBrokerOverrideFluentImpl<NodePortListenerOverrideFluent.BrokersNested<N>> implements NodePortListenerOverrideFluent.BrokersNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final NodePortListenerBrokerOverrideBuilder builder;
        private final int index;
    
            BrokersNestedImpl(int index,NodePortListenerBrokerOverride item){
                    this.index = index;
                    this.builder = new NodePortListenerBrokerOverrideBuilder(this, item);
            }
            BrokersNestedImpl(){
                    this.index = -1;
                    this.builder = new NodePortListenerBrokerOverrideBuilder(this);
            }
    
    public N and(){
            return (N) NodePortListenerOverrideFluentImpl.this.setToBrokers(index, builder.build());
    }
    public N endBroker(){
            return and();
    }

}


}
