package io.strimzi.api.kafka.model.listener;

import java.lang.StringBuffer;
import java.lang.StringBuilder;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class RouteListenerBrokerOverrideFluentImpl<A extends RouteListenerBrokerOverrideFluent<A>> extends ExternalListenerBrokerOverrideFluentImpl<A> implements RouteListenerBrokerOverrideFluent<A>{

    private String host;

    public RouteListenerBrokerOverrideFluentImpl(){
    }
    public RouteListenerBrokerOverrideFluentImpl(RouteListenerBrokerOverride instance){
            this.withHost(instance.getHost());

            this.withBroker(instance.getBroker());

            this.withAdvertisedHost(instance.getAdvertisedHost());

            this.withAdvertisedPort(instance.getAdvertisedPort());

    }

    public String getHost(){
            return this.host;
    }

    public A withHost(String host){
            this.host=host; return (A) this;
    }

    public Boolean hasHost(){
            return this.host != null;
    }

    public A withNewHost(String arg1){
            return (A)withHost(new String(arg1));
    }

    public A withNewHost(StringBuilder arg1){
            return (A)withHost(new String(arg1));
    }

    public A withNewHost(StringBuffer arg1){
            return (A)withHost(new String(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            RouteListenerBrokerOverrideFluentImpl that = (RouteListenerBrokerOverrideFluentImpl) o;
            if (host != null ? !host.equals(that.host) :that.host != null) return false;
            return true;
    }




}
