package io.strimzi.api.kafka.model.listener;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class RouteListenerOverrideBuilder extends RouteListenerOverrideFluentImpl<RouteListenerOverrideBuilder> implements VisitableBuilder<RouteListenerOverride,RouteListenerOverrideBuilder>{

    RouteListenerOverrideFluent<?> fluent;
    Boolean validationEnabled;

    public RouteListenerOverrideBuilder(){
            this(true);
    }
    public RouteListenerOverrideBuilder(Boolean validationEnabled){
            this(new RouteListenerOverride(), validationEnabled);
    }
    public RouteListenerOverrideBuilder(RouteListenerOverrideFluent<?> fluent){
            this(fluent, true);
    }
    public RouteListenerOverrideBuilder(RouteListenerOverrideFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new RouteListenerOverride(), validationEnabled);
    }
    public RouteListenerOverrideBuilder(RouteListenerOverrideFluent<?> fluent,RouteListenerOverride instance){
            this(fluent, instance, true);
    }
    public RouteListenerOverrideBuilder(RouteListenerOverrideFluent<?> fluent,RouteListenerOverride instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withBootstrap(instance.getBootstrap());

            fluent.withBrokers(instance.getBrokers());

            this.validationEnabled = validationEnabled; 
    }
    public RouteListenerOverrideBuilder(RouteListenerOverride instance){
            this(instance,true);
    }
    public RouteListenerOverrideBuilder(RouteListenerOverride instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withBootstrap(instance.getBootstrap());

            this.withBrokers(instance.getBrokers());

            this.validationEnabled = validationEnabled; 
    }

    public RouteListenerOverride build(){
            RouteListenerOverride buildable = new RouteListenerOverride();
            buildable.setBootstrap(fluent.getBootstrap());
            buildable.setBrokers(fluent.getBrokers());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            RouteListenerOverrideBuilder that = (RouteListenerOverrideBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
