package io.strimzi.api.kafka.model.listener.arraylistener;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.strimzi.api.kafka.model.listener.KafkaListeners;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.strimzi.api.kafka.model.listener.KafkaListenersBuilder;
import java.util.Iterator;
import java.util.Collection;
import io.strimzi.api.kafka.model.listener.KafkaListenersFluentImpl;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class ArrayOrObjectKafkaListenersFluentImpl<A extends ArrayOrObjectKafkaListenersFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements ArrayOrObjectKafkaListenersFluent<A>{

    private java.util.List<GenericKafkaListenerBuilder> genericKafkaListeners;
    private KafkaListenersBuilder kafkaListeners;

    public ArrayOrObjectKafkaListenersFluentImpl(){
    }
    public ArrayOrObjectKafkaListenersFluentImpl(ArrayOrObjectKafkaListeners instance){
            this.withGenericKafkaListeners(instance.getGenericKafkaListeners()); 
            this.withKafkaListeners(instance.getKafkaListeners()); 
    }

    public A addToGenericKafkaListeners(int index,GenericKafkaListener item){
            if (this.genericKafkaListeners == null) {this.genericKafkaListeners = new ArrayList<GenericKafkaListenerBuilder>();}
            GenericKafkaListenerBuilder builder = new GenericKafkaListenerBuilder(item);_visitables.get("genericKafkaListeners").add(index >= 0 ? index : _visitables.get("genericKafkaListeners").size(), builder);this.genericKafkaListeners.add(index >= 0 ? index : genericKafkaListeners.size(), builder); return (A)this;
    }

    public A setToGenericKafkaListeners(int index,GenericKafkaListener item){
            if (this.genericKafkaListeners == null) {this.genericKafkaListeners = new ArrayList<GenericKafkaListenerBuilder>();}
            GenericKafkaListenerBuilder builder = new GenericKafkaListenerBuilder(item);
            if (index < 0 || index >= _visitables.get("genericKafkaListeners").size()) { _visitables.get("genericKafkaListeners").add(builder); } else { _visitables.get("genericKafkaListeners").set(index, builder);}
            if (index < 0 || index >= genericKafkaListeners.size()) { genericKafkaListeners.add(builder); } else { genericKafkaListeners.set(index, builder);}
             return (A)this;
    }

    public A addToGenericKafkaListeners(GenericKafkaListener... items){
            if (this.genericKafkaListeners == null) {this.genericKafkaListeners = new ArrayList<GenericKafkaListenerBuilder>();}
            for (GenericKafkaListener item : items) {GenericKafkaListenerBuilder builder = new GenericKafkaListenerBuilder(item);_visitables.get("genericKafkaListeners").add(builder);this.genericKafkaListeners.add(builder);} return (A)this;
    }

    public A addAllToGenericKafkaListeners(Collection<GenericKafkaListener> items){
            if (this.genericKafkaListeners == null) {this.genericKafkaListeners = new ArrayList<GenericKafkaListenerBuilder>();}
            for (GenericKafkaListener item : items) {GenericKafkaListenerBuilder builder = new GenericKafkaListenerBuilder(item);_visitables.get("genericKafkaListeners").add(builder);this.genericKafkaListeners.add(builder);} return (A)this;
    }

    public A removeFromGenericKafkaListeners(GenericKafkaListener... items){
            for (GenericKafkaListener item : items) {GenericKafkaListenerBuilder builder = new GenericKafkaListenerBuilder(item);_visitables.get("genericKafkaListeners").remove(builder);if (this.genericKafkaListeners != null) {this.genericKafkaListeners.remove(builder);}} return (A)this;
    }

    public A removeAllFromGenericKafkaListeners(Collection<GenericKafkaListener> items){
            for (GenericKafkaListener item : items) {GenericKafkaListenerBuilder builder = new GenericKafkaListenerBuilder(item);_visitables.get("genericKafkaListeners").remove(builder);if (this.genericKafkaListeners != null) {this.genericKafkaListeners.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromGenericKafkaListeners(io.fabric8.kubernetes.api.builder.Predicate<GenericKafkaListenerBuilder> predicate){
            if (genericKafkaListeners == null) return (A) this;
            final Iterator<GenericKafkaListenerBuilder> each = genericKafkaListeners.iterator();
            final List visitables = _visitables.get("genericKafkaListeners");
            while (each.hasNext()) {
              GenericKafkaListenerBuilder builder = each.next();
              if (predicate.apply(builder)) {
                visitables.remove(builder);
                each.remove();
              }
            }
            return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildGenericKafkaListeners instead.
 * @return The buildable object.
 */
@Deprecated public java.util.List<GenericKafkaListener> getGenericKafkaListeners(){
            return build(genericKafkaListeners);
    }

    public java.util.List<GenericKafkaListener> buildGenericKafkaListeners(){
            return build(genericKafkaListeners);
    }

    public GenericKafkaListener buildGenericKafkaListener(int index){
            return this.genericKafkaListeners.get(index).build();
    }

    public GenericKafkaListener buildFirstGenericKafkaListener(){
            return this.genericKafkaListeners.get(0).build();
    }

    public GenericKafkaListener buildLastGenericKafkaListener(){
            return this.genericKafkaListeners.get(genericKafkaListeners.size() - 1).build();
    }

    public GenericKafkaListener buildMatchingGenericKafkaListener(io.fabric8.kubernetes.api.builder.Predicate<GenericKafkaListenerBuilder> predicate){
            for (GenericKafkaListenerBuilder item: genericKafkaListeners) { if(predicate.apply(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingGenericKafkaListener(io.fabric8.kubernetes.api.builder.Predicate<GenericKafkaListenerBuilder> predicate){
            for (GenericKafkaListenerBuilder item: genericKafkaListeners) { if(predicate.apply(item)){ return true;} } return false;
    }

    public A withGenericKafkaListeners(java.util.List<GenericKafkaListener> genericKafkaListeners){
            if (this.genericKafkaListeners != null) { _visitables.get("genericKafkaListeners").removeAll(this.genericKafkaListeners);}
            if (genericKafkaListeners != null) {this.genericKafkaListeners = new ArrayList<GenericKafkaListenerBuilder>(); for (GenericKafkaListener item : genericKafkaListeners){this.addToGenericKafkaListeners(item);}} else { this.genericKafkaListeners = null;} return (A) this;
    }

    public A withGenericKafkaListeners(GenericKafkaListener... genericKafkaListeners){
            if (this.genericKafkaListeners != null) {this.genericKafkaListeners.clear();}
            if (genericKafkaListeners != null) {for (GenericKafkaListener item :genericKafkaListeners){ this.addToGenericKafkaListeners(item);}} return (A) this;
    }

    public Boolean hasGenericKafkaListeners(){
            return genericKafkaListeners != null && !genericKafkaListeners.isEmpty();
    }

    public ArrayOrObjectKafkaListenersFluent.GenericKafkaListenersNested<A> addNewGenericKafkaListener(){
            return new GenericKafkaListenersNestedImpl();
    }

    public ArrayOrObjectKafkaListenersFluent.GenericKafkaListenersNested<A> addNewGenericKafkaListenerLike(GenericKafkaListener item){
            return new GenericKafkaListenersNestedImpl(-1, item);
    }

    public ArrayOrObjectKafkaListenersFluent.GenericKafkaListenersNested<A> setNewGenericKafkaListenerLike(int index,GenericKafkaListener item){
            return new GenericKafkaListenersNestedImpl(index, item);
    }

    public ArrayOrObjectKafkaListenersFluent.GenericKafkaListenersNested<A> editGenericKafkaListener(int index){
            if (genericKafkaListeners.size() <= index) throw new RuntimeException("Can't edit genericKafkaListeners. Index exceeds size.");
            return setNewGenericKafkaListenerLike(index, buildGenericKafkaListener(index));
    }

    public ArrayOrObjectKafkaListenersFluent.GenericKafkaListenersNested<A> editFirstGenericKafkaListener(){
            if (genericKafkaListeners.size() == 0) throw new RuntimeException("Can't edit first genericKafkaListeners. The list is empty.");
            return setNewGenericKafkaListenerLike(0, buildGenericKafkaListener(0));
    }

    public ArrayOrObjectKafkaListenersFluent.GenericKafkaListenersNested<A> editLastGenericKafkaListener(){
            int index = genericKafkaListeners.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last genericKafkaListeners. The list is empty.");
            return setNewGenericKafkaListenerLike(index, buildGenericKafkaListener(index));
    }

    public ArrayOrObjectKafkaListenersFluent.GenericKafkaListenersNested<A> editMatchingGenericKafkaListener(io.fabric8.kubernetes.api.builder.Predicate<GenericKafkaListenerBuilder> predicate){
            int index = -1;
            for (int i=0;i<genericKafkaListeners.size();i++) { 
            if (predicate.apply(genericKafkaListeners.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching genericKafkaListeners. No match found.");
            return setNewGenericKafkaListenerLike(index, buildGenericKafkaListener(index));
    }

    
/**
 * This method has been deprecated, please use method buildKafkaListeners instead.
 * @return The buildable object.
 */
@Deprecated public KafkaListeners getKafkaListeners(){
            return this.kafkaListeners!=null?this.kafkaListeners.build():null;
    }

    public KafkaListeners buildKafkaListeners(){
            return this.kafkaListeners!=null?this.kafkaListeners.build():null;
    }

    public A withKafkaListeners(KafkaListeners kafkaListeners){
            _visitables.get("kafkaListeners").remove(this.kafkaListeners);
            if (kafkaListeners!=null){ this.kafkaListeners= new KafkaListenersBuilder(kafkaListeners); _visitables.get("kafkaListeners").add(this.kafkaListeners);} return (A) this;
    }

    public Boolean hasKafkaListeners(){
            return this.kafkaListeners != null;
    }

    public ArrayOrObjectKafkaListenersFluent.KafkaListenersNested<A> withNewKafkaListeners(){
            return new KafkaListenersNestedImpl();
    }

    public ArrayOrObjectKafkaListenersFluent.KafkaListenersNested<A> withNewKafkaListenersLike(KafkaListeners item){
            return new KafkaListenersNestedImpl(item);
    }

    public ArrayOrObjectKafkaListenersFluent.KafkaListenersNested<A> editKafkaListeners(){
            return withNewKafkaListenersLike(getKafkaListeners());
    }

    public ArrayOrObjectKafkaListenersFluent.KafkaListenersNested<A> editOrNewKafkaListeners(){
            return withNewKafkaListenersLike(getKafkaListeners() != null ? getKafkaListeners(): new KafkaListenersBuilder().build());
    }

    public ArrayOrObjectKafkaListenersFluent.KafkaListenersNested<A> editOrNewKafkaListenersLike(KafkaListeners item){
            return withNewKafkaListenersLike(getKafkaListeners() != null ? getKafkaListeners(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            ArrayOrObjectKafkaListenersFluentImpl that = (ArrayOrObjectKafkaListenersFluentImpl) o;
            if (genericKafkaListeners != null ? !genericKafkaListeners.equals(that.genericKafkaListeners) :that.genericKafkaListeners != null) return false;
            if (kafkaListeners != null ? !kafkaListeners.equals(that.kafkaListeners) :that.kafkaListeners != null) return false;
            return true;
    }


    public class GenericKafkaListenersNestedImpl<N> extends GenericKafkaListenerFluentImpl<ArrayOrObjectKafkaListenersFluent.GenericKafkaListenersNested<N>> implements ArrayOrObjectKafkaListenersFluent.GenericKafkaListenersNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final GenericKafkaListenerBuilder builder;
        private final int index;
    
            GenericKafkaListenersNestedImpl(int index,GenericKafkaListener item){
                    this.index = index;
                    this.builder = new GenericKafkaListenerBuilder(this, item);
            }
            GenericKafkaListenersNestedImpl(){
                    this.index = -1;
                    this.builder = new GenericKafkaListenerBuilder(this);
            }
    
    public N and(){
            return (N) ArrayOrObjectKafkaListenersFluentImpl.this.setToGenericKafkaListeners(index, builder.build());
    }
    public N endGenericKafkaListener(){
            return and();
    }

}
    public class KafkaListenersNestedImpl<N> extends KafkaListenersFluentImpl<ArrayOrObjectKafkaListenersFluent.KafkaListenersNested<N>> implements ArrayOrObjectKafkaListenersFluent.KafkaListenersNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final KafkaListenersBuilder builder;
    
            KafkaListenersNestedImpl(KafkaListeners item){
                    this.builder = new KafkaListenersBuilder(this, item);
            }
            KafkaListenersNestedImpl(){
                    this.builder = new KafkaListenersBuilder(this);
            }
    
    public N and(){
            return (N) ArrayOrObjectKafkaListenersFluentImpl.this.withKafkaListeners(builder.build());
    }
    public N endKafkaListeners(){
            return and();
    }

}


}
