package io.strimzi.api.kafka.model.listener.arraylistener;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class GenericKafkaListenerBuilder extends GenericKafkaListenerFluentImpl<GenericKafkaListenerBuilder> implements VisitableBuilder<GenericKafkaListener,GenericKafkaListenerBuilder>{

    GenericKafkaListenerFluent<?> fluent;
    Boolean validationEnabled;

    public GenericKafkaListenerBuilder(){
            this(true);
    }
    public GenericKafkaListenerBuilder(Boolean validationEnabled){
            this(new GenericKafkaListener(), validationEnabled);
    }
    public GenericKafkaListenerBuilder(GenericKafkaListenerFluent<?> fluent){
            this(fluent, true);
    }
    public GenericKafkaListenerBuilder(GenericKafkaListenerFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new GenericKafkaListener(), validationEnabled);
    }
    public GenericKafkaListenerBuilder(GenericKafkaListenerFluent<?> fluent,GenericKafkaListener instance){
            this(fluent, instance, true);
    }
    public GenericKafkaListenerBuilder(GenericKafkaListenerFluent<?> fluent,GenericKafkaListener instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withName(instance.getName());

            fluent.withPort(instance.getPort());

            fluent.withType(instance.getType());

            fluent.withTls(instance.isTls());

            fluent.withAuth(instance.getAuth());

            fluent.withConfiguration(instance.getConfiguration());

            fluent.withNetworkPolicyPeers(instance.getNetworkPolicyPeers());

            this.validationEnabled = validationEnabled; 
    }
    public GenericKafkaListenerBuilder(GenericKafkaListener instance){
            this(instance,true);
    }
    public GenericKafkaListenerBuilder(GenericKafkaListener instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withName(instance.getName());

            this.withPort(instance.getPort());

            this.withType(instance.getType());

            this.withTls(instance.isTls());

            this.withAuth(instance.getAuth());

            this.withConfiguration(instance.getConfiguration());

            this.withNetworkPolicyPeers(instance.getNetworkPolicyPeers());

            this.validationEnabled = validationEnabled; 
    }

    public GenericKafkaListener build(){
            GenericKafkaListener buildable = new GenericKafkaListener();
            buildable.setName(fluent.getName());
            buildable.setPort(fluent.getPort());
            buildable.setType(fluent.getType());
            buildable.setTls(fluent.isTls());
            buildable.setAuth(fluent.getAuth());
            buildable.setConfiguration(fluent.getConfiguration());
            buildable.setNetworkPolicyPeers(fluent.getNetworkPolicyPeers());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            GenericKafkaListenerBuilder that = (GenericKafkaListenerBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
