package io.strimzi.api.kafka.model.listener.arraylistener;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class GenericKafkaListenerConfigurationBrokerBuilder extends GenericKafkaListenerConfigurationBrokerFluentImpl<GenericKafkaListenerConfigurationBrokerBuilder> implements VisitableBuilder<GenericKafkaListenerConfigurationBroker,GenericKafkaListenerConfigurationBrokerBuilder>{

    GenericKafkaListenerConfigurationBrokerFluent<?> fluent;
    Boolean validationEnabled;

    public GenericKafkaListenerConfigurationBrokerBuilder(){
            this(true);
    }
    public GenericKafkaListenerConfigurationBrokerBuilder(Boolean validationEnabled){
            this(new GenericKafkaListenerConfigurationBroker(), validationEnabled);
    }
    public GenericKafkaListenerConfigurationBrokerBuilder(GenericKafkaListenerConfigurationBrokerFluent<?> fluent){
            this(fluent, true);
    }
    public GenericKafkaListenerConfigurationBrokerBuilder(GenericKafkaListenerConfigurationBrokerFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new GenericKafkaListenerConfigurationBroker(), validationEnabled);
    }
    public GenericKafkaListenerConfigurationBrokerBuilder(GenericKafkaListenerConfigurationBrokerFluent<?> fluent,GenericKafkaListenerConfigurationBroker instance){
            this(fluent, instance, true);
    }
    public GenericKafkaListenerConfigurationBrokerBuilder(GenericKafkaListenerConfigurationBrokerFluent<?> fluent,GenericKafkaListenerConfigurationBroker instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withBroker(instance.getBroker());

            fluent.withAdvertisedHost(instance.getAdvertisedHost());

            fluent.withAdvertisedPort(instance.getAdvertisedPort());

            fluent.withHost(instance.getHost());

            fluent.withAnnotations(instance.getAnnotations());

            fluent.withNodePort(instance.getNodePort());

            fluent.withLoadBalancerIP(instance.getLoadBalancerIP());

            this.validationEnabled = validationEnabled; 
    }
    public GenericKafkaListenerConfigurationBrokerBuilder(GenericKafkaListenerConfigurationBroker instance){
            this(instance,true);
    }
    public GenericKafkaListenerConfigurationBrokerBuilder(GenericKafkaListenerConfigurationBroker instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withBroker(instance.getBroker());

            this.withAdvertisedHost(instance.getAdvertisedHost());

            this.withAdvertisedPort(instance.getAdvertisedPort());

            this.withHost(instance.getHost());

            this.withAnnotations(instance.getAnnotations());

            this.withNodePort(instance.getNodePort());

            this.withLoadBalancerIP(instance.getLoadBalancerIP());

            this.validationEnabled = validationEnabled; 
    }

    public GenericKafkaListenerConfigurationBroker build(){
            GenericKafkaListenerConfigurationBroker buildable = new GenericKafkaListenerConfigurationBroker();
            buildable.setBroker(fluent.getBroker());
            buildable.setAdvertisedHost(fluent.getAdvertisedHost());
            buildable.setAdvertisedPort(fluent.getAdvertisedPort());
            buildable.setHost(fluent.getHost());
            buildable.setAnnotations(fluent.getAnnotations());
            buildable.setNodePort(fluent.getNodePort());
            buildable.setLoadBalancerIP(fluent.getLoadBalancerIP());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            GenericKafkaListenerConfigurationBrokerBuilder that = (GenericKafkaListenerConfigurationBrokerBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
